/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.clipboard;

import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.clipboard.IClipboardEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class EntityClipboardEntry
implements IClipboardEntry {
    private final CompoundNBT entityTag;
    private EntityType<?> entityType;
    private Entity entity;

    public EntityClipboardEntry(Entity entity) {
        this.entityTag = ClientUtils.getCleanEntityTag(entity);
    }

    public EntityClipboardEntry(PacketBuffer buffer) {
        this.entityTag = buffer.func_150793_b();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a(this.entityTag);
    }

    public CompoundNBT getEntityTag() {
        return this.entityTag;
    }

    public EntityType<?> getEntityType() {
        if (this.entityType == null) {
            this.entityType = EntityType.func_220327_a((String)this.entityTag.func_74779_i("id")).orElse(EntityType.field_200784_X);
        }
        return this.entityType;
    }

    public Entity getEntity() {
        if (this.entity == null) {
            this.entity = ClientUtils.createEntity(this.getEntityType(), this.entityTag);
        }
        return this.entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityClipboardEntry entry = (EntityClipboardEntry)o;
        return this.entityTag.equals((Object)entry.entityTag);
    }

    public int hashCode() {
        return this.entityTag.hashCode();
    }
}

