/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.clipboard;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.group.VBox;
import com.github.franckyi.guapi.math.Insets;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.Label;
import com.github.franckyi.guapi.node.ListExtended;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.guapi.scene.IBackground;
import com.github.franckyi.ibeeditor.client.EntityIcons;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.clipboard.IBEClipboard;
import com.github.franckyi.ibeeditor.client.clipboard.ItemClipboardEntry;
import com.github.franckyi.ibeeditor.client.gui.IResizable;
import com.github.franckyi.ibeeditor.common.IBEConfiguration;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractClipboard
extends Scene {
    protected final VBox content = (VBox)this.getContent();
    protected final Label header;
    protected final ListExtended<ClipboardView> body;
    protected final HBox footer;
    protected Filter filter;

    public AbstractClipboard(String headerText) {
        super(new VBox());
        this.header = new Label(TextFormatting.UNDERLINE + headerText);
        this.header.setPrefHeight(30);
        this.header.setCentered(true);
        this.body = new ListExtended(25);
        this.body.setOffset(new Insets(0, 10, 10, 10));
        this.footer = new HBox(20);
        this.footer.setAlignment(Pos.CENTER);
        this.footer.setPrefHeight(20);
        this.content.getChildren().add(this.header);
        this.content.getChildren().add(this.body);
        this.content.getChildren().add(this.footer);
        this.setContentFullScreen();
        this.setBackground(IBackground.texturedBackground(1));
        this.getOnInitGuiListeners().add(e -> {
            this.setContentFullScreen();
            this.scaleChildrenSize();
        });
        this.setGuiPauseGame((Boolean)IBEConfiguration.CLIENT.doesGuiPauseGame.get());
    }

    protected void scaleChildrenSize() {
        this.header.setPrefWidth(this.content.getWidth());
        this.footer.setPrefWidth(this.content.getWidth());
        this.body.setPrefSize(this.content.getWidth(), this.content.getHeight() - 60);
        ((ListExtended.GuiListExtendedView)this.body.getView()).setHeight(this.content.getHeight());
        this.scaleEntriesSize();
    }

    private void scaleEntriesSize() {
        this.body.getChildren().forEach(resizable -> resizable.updateSize(this.content.getWidth()));
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.body.render(mouseX, mouseY, partialTicks);
        this.header.render(mouseX, mouseY, partialTicks);
        this.footer.render(mouseX, mouseY, partialTicks);
        if (this.body.getChildren().isEmpty()) {
            this.getScreen().drawCenteredString(AbstractClipboard.mc.field_71466_p, "The selection is empty !", this.getScreen().width / 2, this.body.getY() + this.body.getHeight() / 2 - 4, TextFormatting.DARK_RED.func_211163_e());
        }
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
        IBEClipboard clipboard = IBEClipboard.getInstance();
        this.body.getChildren().clear();
        switch (filter) {
            case ALL: {
                clipboard.getItems().forEach(this::newItemEntry);
                clipboard.getEntities().forEach(this::newEntityEntry);
                break;
            }
            case ITEM: {
                clipboard.getItems().forEach(this::newItemEntry);
                break;
            }
            case ENTITY: {
                clipboard.getEntities().forEach(this::newEntityEntry);
            }
        }
        this.scaleEntriesSize();
    }

    protected abstract void newItemEntry(ItemClipboardEntry var1);

    protected abstract void newEntityEntry(EntityClipboardEntry var1);

    protected static abstract class EntityViewBase
    extends ClipboardView {
        protected final TexturedButton entityButton;
        protected final Label nameLabel;
        protected Entity entity;
        protected List<Node<?>> children;

        public EntityViewBase(EntityClipboardEntry entity) {
            super(new HBox(10));
            ((HBox)this.getNode()).setAlignment(Pos.LEFT);
            this.entity = entity.getEntity();
            this.children = ((HBox)this.getNode()).getChildren();
            this.entityButton = EntityIcons.createTexturedButtonForEntity(entity.getEntityType());
            this.children.add(this.entityButton);
            this.entityButton.setMargin(Insets.left(5));
            this.nameLabel = new Label(entity.getEntityType().func_212546_e().func_150254_d());
            this.children.add(this.nameLabel);
        }
    }

    protected static abstract class ItemViewBase
    extends ClipboardView {
        protected final TexturedButton itemButton;
        protected final Label nameLabel;
        protected ItemStack itemStack;
        protected List<Node<?>> children;

        public ItemViewBase(ItemClipboardEntry item) {
            super(new HBox(10));
            ((HBox)this.getNode()).setAlignment(Pos.LEFT);
            this.itemStack = item.getItemStack();
            this.children = ((HBox)this.getNode()).getChildren();
            this.itemButton = new TexturedButton(this.itemStack);
            this.children.add(this.itemButton);
            this.itemButton.setMargin(Insets.left(5));
            this.nameLabel = new Label(this.itemStack.func_200301_q().func_150254_d());
            this.children.add(this.nameLabel);
        }

        @Override
        public abstract void updateSize(int var1);
    }

    protected static abstract class ClipboardView
    extends ListExtended.NodeEntry<HBox>
    implements IResizable {
        public ClipboardView(HBox node) {
            super(node);
        }
    }

    public static enum Filter {
        ALL("All"),
        ITEM("Item"),
        ENTITY("Entity");

        private final String s;

        private Filter(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

