/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.clipboard;

import com.github.franckyi.guapi.node.Button;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.clipboard.IClipboardEntry;
import com.github.franckyi.ibeeditor.client.clipboard.ItemClipboardEntry;
import com.github.franckyi.ibeeditor.client.gui.clipboard.AbstractClipboard;
import java.util.function.Consumer;
import net.minecraft.util.text.TextFormatting;

public class SelectionClipboard<T extends IClipboardEntry>
extends AbstractClipboard {
    private final Button cancelButton;
    private final Consumer<T> afterSelection;

    public SelectionClipboard(AbstractClipboard.Filter filter, Consumer<T> afterSelection) {
        super("IBE Clipboard : Select an " + (Object)((Object)filter));
        this.afterSelection = afterSelection;
        this.cancelButton = new Button(TextFormatting.RED + "Cancel");
        this.footer.getChildren().add(this.cancelButton);
        this.cancelButton.setPrefWidth(80);
        this.cancelButton.getOnMouseClickedListeners().add(event -> this.close());
        this.setFilter(filter);
        this.show();
    }

    @Override
    protected void newItemEntry(ItemClipboardEntry item) {
        this.body.getChildren().add(new ItemView(item));
    }

    @Override
    protected void newEntityEntry(EntityClipboardEntry entity) {
        this.body.getChildren().add(new EntityView(entity));
    }

    private class EntityView
    extends AbstractClipboard.EntityViewBase {
        private final Button selectButton;

        public EntityView(EntityClipboardEntry entity) {
            super(entity);
            this.selectButton = new Button(TextFormatting.GREEN + "Select");
            this.children.add(this.selectButton);
            this.selectButton.setPrefWidth(80);
            this.selectButton.getOnMouseClickedListeners().add(e -> {
                SelectionClipboard.this.afterSelection.accept(entity);
                SelectionClipboard.this.close();
            });
        }

        @Override
        public void updateSize(int listWidth) {
            this.nameLabel.setPrefWidth(listWidth - 0 - 161);
        }
    }

    private class ItemView
    extends AbstractClipboard.ItemViewBase {
        private final Button selectButton;

        public ItemView(ItemClipboardEntry item) {
            super(item);
            this.selectButton = new Button(TextFormatting.GREEN + "Select");
            this.children.add(this.selectButton);
            this.selectButton.setPrefWidth(80);
            this.selectButton.getOnMouseClickedListeners().add(e -> {
                SelectionClipboard.this.afterSelection.accept(item);
                SelectionClipboard.this.close();
            });
        }

        @Override
        public void updateSize(int listWidth) {
            this.nameLabel.setPrefWidth(listWidth - 0 - 161);
        }
    }
}

