/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.clipboard;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.node.Button;
import com.github.franckyi.guapi.node.EnumButton;
import com.github.franckyi.guapi.node.Label;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.clipboard.IBEClipboard;
import com.github.franckyi.ibeeditor.client.clipboard.ItemClipboardEntry;
import com.github.franckyi.ibeeditor.client.gui.clipboard.AbstractClipboard;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.item.ItemEditor;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ViewClipboard
extends AbstractClipboard {
    protected final HBox filterBox = new HBox(5);
    protected final Label filterLabel;
    protected final EnumButton<AbstractClipboard.Filter> filterButton;
    protected final Button closeButton;
    protected final HBox blankBox;

    public ViewClipboard() {
        super("IBE Clipboard");
        this.footer.getChildren().add(this.filterBox);
        this.filterLabel = new Label("Filter :");
        this.filterBox.getChildren().add(this.filterLabel);
        this.filterLabel.setPrefHeight(20);
        this.filterButton = new EnumButton<AbstractClipboard.Filter>((T[])AbstractClipboard.Filter.values());
        this.filterBox.getChildren().add(this.filterButton);
        this.filterButton.getOnValueChangedListeners().add((oldVal, newVal) -> this.setFilter((AbstractClipboard.Filter)((Object)newVal)));
        this.filterButton.setValue(AbstractClipboard.Filter.ITEM);
        this.closeButton = new Button(TextFormatting.GREEN + "Close");
        this.footer.getChildren().add(this.closeButton);
        this.closeButton.getOnMouseClickedListeners().add(event -> this.close());
        this.closeButton.setPrefWidth(80);
        this.blankBox = new HBox();
        this.footer.getChildren().add(this.blankBox);
        this.show();
    }

    @Override
    protected void scaleChildrenSize() {
        super.scaleChildrenSize();
        this.blankBox.setPrefWidth(this.filterBox.getWidth());
    }

    @Override
    protected void newItemEntry(ItemClipboardEntry item) {
        this.body.getChildren().add(new ItemView(item));
    }

    @Override
    protected void newEntityEntry(EntityClipboardEntry entity) {
        this.body.getChildren().add(new EntityView(entity));
    }

    protected class EntityView
    extends AbstractClipboard.EntityViewBase {
        private final Button editButton;
        private final TexturedButton removeButton;

        public EntityView(EntityClipboardEntry entity) {
            super(entity);
            List<Node<?>> children = ((HBox)this.getNode()).getChildren();
            this.editButton = new Button("Open in Entity Editor");
            children.add(this.editButton);
            this.editButton.setPrefWidth(170);
            this.editButton.getOnMouseClickedListeners().add(event -> new EntityEditor(this.entity, entity0 -> {
                List<EntityClipboardEntry> entities = IBEClipboard.getInstance().getEntities();
                entities.set(entities.indexOf(entity), new EntityClipboardEntry((Entity)entity0));
                IBEClipboard.getInstance().save();
                ViewClipboard.this.setFilter(ViewClipboard.this.filter);
            }));
            this.removeButton = new TexturedButton("delete.png", TextFormatting.RED + "Remove");
            children.add(this.removeButton);
            this.removeButton.getOnMouseClickedListeners().add(event -> {
                IBEClipboard.getInstance().removeEntity(entity);
                ViewClipboard.this.setFilter(ViewClipboard.this.filter);
            });
        }

        @Override
        public void updateSize(int listWidth) {
            this.nameLabel.setPrefWidth(listWidth - 0 - 281);
        }
    }

    protected class ItemView
    extends AbstractClipboard.ItemViewBase {
        private final Button editButton;
        private final TexturedButton removeButton;

        public ItemView(ItemClipboardEntry item) {
            super(item);
            List<Node<?>> children = ((HBox)this.getNode()).getChildren();
            this.editButton = new Button("Open in Item Editor");
            children.add(this.editButton);
            this.editButton.setPrefWidth(170);
            this.editButton.getOnMouseClickedListeners().add(event -> ItemEditor.withConsumer(this.itemStack, stack -> {
                List<ItemClipboardEntry> items = IBEClipboard.getInstance().getItems();
                items.set(items.indexOf(item), new ItemClipboardEntry((ItemStack)stack));
                IBEClipboard.getInstance().save();
                ViewClipboard.this.setFilter(ViewClipboard.this.filter);
            }));
            this.removeButton = new TexturedButton("delete.png", TextFormatting.RED + "Remove");
            children.add(this.removeButton);
            this.removeButton.getOnMouseClickedListeners().add(event -> {
                IBEClipboard.getInstance().removeItem(item);
                ViewClipboard.this.setFilter(ViewClipboard.this.filter);
            });
        }

        @Override
        public void updateSize(int listWidth) {
            this.nameLabel.setPrefWidth(listWidth - 0 - 281);
        }
    }
}

