/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base.property;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.math.Insets;
import com.github.franckyi.guapi.node.EnumButton;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.LabeledProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class PropertyEnum<T>
extends LabeledProperty<T> {
    protected EnumButton<T> enumButton;

    public PropertyEnum(String name, T initialValue, Collection<T> values, Consumer<T> action) {
        this(name, initialValue, values, action, t -> StringUtils.capitalize((String)t.toString().toLowerCase()));
    }

    public PropertyEnum(String name, T initialValue, Collection<T> values, Consumer<T> action, Function<T, String> renderer) {
        super(name, initialValue, action);
        this.enumButton.setValues(new ArrayList<T>(values));
        this.enumButton.setValue(initialValue);
        this.enumButton.setRenderer(renderer);
    }

    @Override
    protected void build() {
        super.build();
        Node[] nodeArray = new Node[1];
        this.enumButton = new EnumButton<Object>(new Object[0]);
        nodeArray[0] = this.enumButton;
        this.addAll(nodeArray);
        this.enumButton.setMargin(Insets.right(5));
    }

    @Override
    public void updateSize(int listWidth) {
        this.nameLabel.setPrefWidth(listWidth - this.enumButton.getWidth() - 0 - 67);
    }

    @Override
    protected T getValue() {
        return this.enumButton.getValue();
    }

    @Override
    protected void setValue(T value) {
        this.enumButton.setValue(value);
    }
}

