/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.node.CheckBox;
import com.github.franckyi.guapi.node.TextFieldBase;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.BasePotionEffectProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.model.PotionEffectModel;
import java.util.function.Consumer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPotionEffectProperty
extends BasePotionEffectProperty<PotionEffectModel> {
    private CheckBox ambient;
    private CheckBox showParticles;
    private CheckBox showIcon;

    public ItemPotionEffectProperty(EditableCategory<?> category, int index, PotionEffectModel initialValue, Consumer<PotionEffectModel> action) {
        super(category, index, initialValue, action);
        if (initialValue.isDisabled()) {
            this.resetButton.setDisabled(true);
            this.controls.getRemove().setDisabled(true);
        }
    }

    @Override
    public PotionEffectModel getValue() {
        return new PotionEffectModel((Effect)ForgeRegistries.POTIONS.getValue(ResourceLocation.func_208304_a((String)this.name.getValue())), (Integer)this.duration.getValue(), (Integer)this.amplifier.getValue(), this.ambient.getValue(), this.showParticles.getValue(), this.showIcon.getValue(), ((PotionEffectModel)((Object)this.initialValue)).isDisabled());
    }

    @Override
    protected void setValue(PotionEffectModel value) {
        super.setValue(value);
        this.ambient.setValue(value.func_82720_e());
        this.showParticles.setValue(value.func_188418_e());
        this.showIcon.setValue(value.func_205348_f());
        if (value.isDisabled()) {
            ((TextFieldBase.GuiTextFieldView)this.name.getView()).func_146184_c(false);
            ((TextFieldBase.GuiTextFieldView)this.amplifier.getView()).func_146184_c(false);
            ((TextFieldBase.GuiTextFieldView)this.duration.getView()).func_146184_c(false);
            this.ambient.setDisabled(true);
            this.showParticles.setDisabled(true);
            this.showIcon.setDisabled(true);
        }
    }

    @Override
    public void build() {
        super.build();
        Node[] nodeArray = new Node[3];
        this.ambient = new CheckBox("A");
        nodeArray[0] = this.ambient;
        this.showParticles = new CheckBox("P");
        nodeArray[1] = this.showParticles;
        this.showIcon = new CheckBox("I");
        nodeArray[2] = this.showIcon;
        this.addAll(nodeArray);
        this.ambient.getTooltipText().add("Ambient");
        this.showParticles.getTooltipText().add("Show particles");
        this.showIcon.getTooltipText().add("Show icon");
    }

    @Override
    public void updateSize(int listWidth) {
        this.name.setPrefWidth(listWidth - 0 - 195);
    }
}

