/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.block;

import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.EditorHelper;
import com.github.franckyi.ibeeditor.client.IBENotification;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.base.CapabilityProviderEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.block.BlockStateCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.block.ToolsBlockCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.block.tileentity.CommandBlockCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.block.tileentity.LockableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.block.tileentity.MobSpawnerCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.block.tileentity.SpawnPotentialsCategory;
import com.github.franckyi.ibeeditor.common.network.IBENetworkHandler;
import com.github.franckyi.ibeeditor.common.network.editor.block.BlockEditorMessage;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class BlockEditor
extends CapabilityProviderEditor {
    private final BlockPos blockPos;
    private TileEntity tileEntity;
    private BlockState blockState;

    public BlockEditor(BlockPos blockPos, TileEntity tileEntity) {
        super("Block Editor :");
        this.blockPos = blockPos;
        this.tileEntity = tileEntity;
        this.blockState = BlockEditor.mc.field_71441_e.func_180495_p(blockPos);
        this.header.getChildren().add(new TexturedButton(new ItemStack((IItemProvider)this.blockState.func_177230_c())));
        if (!this.blockState.func_206869_a().isEmpty()) {
            this.addCategory("Block state", new BlockStateCategory(this));
        }
        if (tileEntity != null) {
            this.applyConfigurations(this.getCapabilityConfigurations(), tileEntity);
            this.applyConfigurations(BlockEditorConfiguration.config, tileEntity);
        }
        this.addCategory("Tools", new ToolsBlockCategory(this));
        this.show();
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    @Override
    protected void apply() {
        BlockState baseState = this.blockState;
        CompoundNBT teTag = null;
        if (this.tileEntity != null) {
            teTag = this.tileEntity.func_189515_b(new CompoundNBT());
        }
        super.apply();
        if (baseState.equals(this.blockState) && (teTag == null || teTag.equals((Object)this.tileEntity.func_189515_b(new CompoundNBT())))) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "Nothing to save.");
        } else if (EditorHelper.isServerEnabled()) {
            IBENetworkHandler.getModChannel().sendToServer((Object)new BlockEditorMessage(this.blockPos, this.blockState, this.tileEntity));
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Block saved.");
        } else {
            ClientUtils.sendCommand(ClientUtils.getSetblockCommand(this.blockPos, new BlockState(Blocks.field_150350_a, ImmutableMap.of()), null));
            if (ClientUtils.handleCommand(ClientUtils.getSetblockCommand(this.blockPos, this.blockState, this.tileEntity))) {
                IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Block saved.");
            }
        }
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    protected static class BlockEditorConfiguration<T>
    extends AbstractEditor.AbstractEditorConfiguration<TileEntity, T> {
        private static final List<? extends BlockEditorConfiguration<Object>> config = BlockEditorConfiguration.build();

        private BlockEditorConfiguration(Predicate<TileEntity> condition, Function<TileEntity, T> caster, String name, Function<T, AbstractCategory> categoryBuilder) {
            super(condition, caster, name, categoryBuilder);
        }

        private static List<BlockEditorConfiguration<Object>> build() {
            return Arrays.asList(BlockEditorConfiguration.create(LockableTileEntity.class, "Name", LockableCategory::new), BlockEditorConfiguration.create(CommandBlockTileEntity.class, "Command block", CommandBlockCategory::new), BlockEditorConfiguration.create(MobSpawnerTileEntity.class, "Mob Spawner", MobSpawnerCategory::new), BlockEditorConfiguration.create(MobSpawnerTileEntity.class, "Spawn Potentials", SpawnPotentialsCategory::new));
        }

        private static <T> BlockEditorConfiguration create(Class<T> teClass, String name, Function<T, AbstractCategory> categoryBuilder) {
            return new BlockEditorConfiguration<Object>(teClass::isInstance, teClass::cast, name, (Function<Object, AbstractCategory>)categoryBuilder);
        }
    }
}

