/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.block.tileentity;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Insets;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.Button;
import com.github.franckyi.guapi.node.IntegerField;
import com.github.franckyi.guapi.node.Label;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.EntityIcons;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.gui.clipboard.AbstractClipboard;
import com.github.franckyi.ibeeditor.client.gui.clipboard.SelectionClipboard;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.IEditableCategoryProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;

public class SpawnPotentialsCategory
extends EditableCategory<SpawnPotentialModel> {
    private final MobSpawnerTileEntity tileEntity;
    private final List<SpawnPotentialModel> spawnPotentialList;
    private final CompoundNBT tag;
    private ListNBT spawnPotentialsTag;

    public SpawnPotentialsCategory(MobSpawnerTileEntity tileEntity) {
        this.tileEntity = tileEntity;
        this.spawnPotentialList = new ArrayList<SpawnPotentialModel>();
        this.tag = new CompoundNBT();
        tileEntity.func_189515_b(this.tag);
        this.spawnPotentialsTag = this.tag.func_150295_c("SpawnPotentials", 10);
        this.getChildren().add(new EditableCategory.AddButton((EditableCategory)this, "Add spawn potential"));
        for (int i = 0; i < this.spawnPotentialsTag.size(); ++i) {
            CompoundNBT spawnPotential = this.spawnPotentialsTag.func_150305_b(i);
            this.addProperty(new SpawnPotentialModel(spawnPotential.func_74762_e("Weight"), spawnPotential.func_74775_l("Entity")));
        }
    }

    @Override
    protected AbstractProperty<SpawnPotentialModel> createNewProperty(SpawnPotentialModel initialValue, int index) {
        return new SpawnPotentialProperty(index, initialValue, this.spawnPotentialList::add);
    }

    @Override
    protected SpawnPotentialModel getDefaultPropertyValue() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", "minecraft:pig");
        return new SpawnPotentialModel(0, tag);
    }

    @Override
    public void apply() {
        this.tileEntity.func_189515_b(this.tag);
        this.spawnPotentialsTag = this.tag.func_150295_c("SpawnPotentials", 10);
        this.spawnPotentialList.clear();
        this.spawnPotentialsTag.clear();
        super.apply();
        this.spawnPotentialList.forEach(spawnPotential -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("Weight", ((SpawnPotentialModel)spawnPotential).weight);
            tag.func_218657_a("Entity", (INBT)((SpawnPotentialModel)spawnPotential).tag);
            this.spawnPotentialsTag.add((Object)tag);
        });
        this.tileEntity.func_145839_a(this.tag);
    }

    private class SpawnPotentialProperty
    extends AbstractProperty<SpawnPotentialModel>
    implements IEditableCategoryProperty {
        private IEditableCategoryProperty.PropertyControls controls;
        private CompoundNBT tag;
        private TexturedButton entityButton;
        private Label weightLabel;
        private IntegerField weightField;
        private Button editButton;
        private Button replaceButton;

        public SpawnPotentialProperty(int index, SpawnPotentialModel initialValue, Consumer<SpawnPotentialModel> action) {
            super(initialValue, action);
            this.controls = new IEditableCategoryProperty.PropertyControls(SpawnPotentialsCategory.this, index);
            IEditableCategoryProperty.super.build();
        }

        @Override
        protected SpawnPotentialModel getValue() {
            return new SpawnPotentialModel((Integer)this.weightField.getValue(), this.tag);
        }

        @Override
        protected void setValue(SpawnPotentialModel value) {
            this.tag = value.tag;
            this.weightField.setValue(value.weight);
            this.updateEntityButton();
        }

        @Override
        public void build() {
            ((HBox)this.getNode()).setAlignment(Pos.LEFT);
            Node[] nodeArray = new Node[5];
            this.entityButton = EntityIcons.createTexturedButtonForEntity(EntityType.field_200784_X);
            nodeArray[0] = this.entityButton;
            this.weightLabel = new Label("Weight :");
            nodeArray[1] = this.weightLabel;
            this.weightField = new IntegerField();
            nodeArray[2] = this.weightField;
            this.editButton = new Button("Editor", "Open in Entity Editor");
            nodeArray[3] = this.editButton;
            this.replaceButton = new Button("Clipboard", "Replace with Clipboard...");
            nodeArray[4] = this.replaceButton;
            this.addAll(nodeArray);
            this.weightLabel.setMargin(Insets.horizontal(5));
            this.editButton.getOnMouseClickedListeners().add(e -> new EntityEditor(ClientUtils.createEntity(this.tag), this::updateEntity));
            this.replaceButton.getOnMouseClickedListeners().add(e -> new SelectionClipboard<EntityClipboardEntry>(AbstractClipboard.Filter.ENTITY, this::updateEntity));
        }

        private void updateEntity(EntityClipboardEntry entry) {
            this.tag = entry.getEntityTag();
            this.updateEntityButton();
        }

        private void updateEntity(Entity entity) {
            this.tag = ClientUtils.getCleanEntityTag(entity);
            this.updateEntityButton();
        }

        private void updateEntityButton() {
            EntityType.func_220327_a((String)this.tag.func_74779_i("id")).ifPresent(entityType -> {
                this.entityButton = EntityIcons.createTexturedButtonForEntity(entityType);
                Node cfr_ignored_0 = ((HBox)this.getNode()).getChildren().set(0, this.entityButton);
            });
        }

        @Override
        public IEditableCategoryProperty.PropertyControls getControls() {
            return this.controls;
        }

        @Override
        public void updateSize(int listWidth) {
            this.weightField.setPrefWidth(listWidth - 0 - 246);
        }
    }

    protected static class SpawnPotentialModel {
        private int weight;
        private CompoundNBT tag;

        private SpawnPotentialModel(int weight, CompoundNBT tag) {
            this.weight = weight;
            this.tag = tag;
        }
    }
}

