/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.entity;

import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.EditorHelper;
import com.github.franckyi.ibeeditor.client.EntityIcons;
import com.github.franckyi.ibeeditor.client.IBENotification;
import com.github.franckyi.ibeeditor.client.gui.editor.base.CapabilityProviderEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityAttributesCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityPotionEffectsCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.GeneralEntityCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.InventoryEntityCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.LootChancesCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.LootTableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.ToolsEntityCategory;
import com.github.franckyi.ibeeditor.common.network.IBENetworkHandler;
import com.github.franckyi.ibeeditor.common.network.editor.entity.EntityEditorMessage;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.TextFormatting;

public class EntityEditor
extends CapabilityProviderEditor {
    private final Entity entity;
    private final Consumer<Entity> action;

    public EntityEditor(Entity entity) {
        this(entity, null);
    }

    public EntityEditor(Entity entity, Consumer<Entity> action) {
        super("Entity Editor :");
        this.entity = entity;
        this.action = action;
        this.header.getChildren().add(EntityIcons.createTexturedButtonForEntity(entity.func_200600_R()));
        this.addCategory("General", new GeneralEntityCategory(entity));
        if (!(entity instanceof PlayerEntity)) {
            if (entity instanceof LivingEntity) {
                this.addCategory("Inventory", new InventoryEntityCategory((LivingEntity)entity));
                this.addCategory("Base Attributes", new EntityAttributesCategory((LivingEntity)entity));
                this.addCategory("Potion Effects", new EntityPotionEffectsCategory((LivingEntity)entity));
                if (entity instanceof MobEntity) {
                    this.addCategory("Loot chances", new LootChancesCategory((MobEntity)entity));
                    if (!(entity instanceof FoxEntity)) {
                        this.addCategory("Loot table", new LootTableCategory((MobEntity)entity));
                    }
                }
            }
            this.addCategory("Tools", new ToolsEntityCategory(entity));
        }
        this.show();
    }

    @Override
    protected void apply() {
        CompoundNBT entityTag = this.entity.func_189511_e(new CompoundNBT());
        super.apply();
        CompoundNBT newTag = this.entity.func_189511_e(new CompoundNBT());
        if (entityTag.equals((Object)newTag)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "Nothing to save.");
        } else if (this.action != null) {
            this.action.accept(this.entity);
        } else if (EditorHelper.isServerEnabled()) {
            IBENetworkHandler.getModChannel().sendToServer((Object)new EntityEditorMessage(this.entity));
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Entity saved.");
        } else if (ClientUtils.handleCommand(ClientUtils.getEntityData(this.entity, (INBT)newTag))) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Entity saved.");
        }
    }
}

