/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.IOrderableEditableCategoryProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.PropertyBoolean;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.PropertyFormattedText;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.PropertyInteger;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GeneralItemCategory
extends EditableCategory<String> {
    private final ItemStack itemStack;
    private boolean flag;

    public GeneralItemCategory(ItemStack itemStack) {
        super(4);
        CompoundNBT display;
        CompoundNBT tag;
        this.itemStack = itemStack;
        AbstractProperty[] abstractPropertyArray = new AbstractProperty[5];
        abstractPropertyArray[0] = new PropertyFormattedText("Name", itemStack.func_200301_q().func_150254_d(), this::setName);
        abstractPropertyArray[1] = new PropertyBoolean("Unbreakable", this.hasUnbreakable(), this::setUnbreakable);
        abstractPropertyArray[2] = new PropertyInteger("Count", itemStack.func_190916_E(), arg_0 -> ((ItemStack)itemStack).func_190920_e(arg_0), 1, 127);
        abstractPropertyArray[3] = new PropertyInteger("Damage", itemStack.func_77952_i(), this::setDamage);
        abstractPropertyArray[4] = new EditableCategory.AddButton((EditableCategory)this, "Add lore");
        this.addAll(abstractPropertyArray);
        if (itemStack.func_77942_o() && (tag = itemStack.func_196082_o()).func_150297_b("display", 10) && (display = itemStack.func_190925_c("display")).func_150297_b("Lore", 9)) {
            int i;
            ListNBT loreTag = display.func_150295_c("Lore", 8);
            for (i = 0; i < loreTag.size(); ++i) {
                JsonObject obj = JSONUtils.func_212745_a((String)loreTag.func_150307_f(i));
                this.addProperty(obj.getAsJsonPrimitive("text").getAsString());
            }
            for (i = 0; i < this.getPropertyCount(); ++i) {
                this.getProperty(i).update(i);
            }
        }
    }

    private void setDamage(int damage) {
        if (damage == 0) {
            this.itemStack.func_196082_o().func_82580_o("Damage");
        } else {
            this.itemStack.func_196085_b(damage);
        }
    }

    private void setName(String s) {
        TranslationTextComponent baseName = new TranslationTextComponent(this.itemStack.func_77973_b().func_77667_c(this.itemStack), new Object[0]);
        if (baseName.func_150261_e().equals(s)) {
            this.itemStack.func_196082_o().func_82580_o("display");
        } else {
            this.itemStack.func_200302_a((ITextComponent)new StringTextComponent(s));
        }
    }

    private boolean hasUnbreakable() {
        return this.itemStack.func_196082_o().func_150297_b("Unbreakable", 1);
    }

    @Override
    public void apply() {
        this.itemStack.func_196082_o().func_82580_o("Unbreakable");
        this.flag = true;
        super.apply();
    }

    private void setLore(String lore) {
        if (this.flag) {
            this.itemStack.func_190925_c("display").func_218657_a("Lore", (INBT)new ListNBT());
            this.flag = false;
        }
        this.itemStack.func_190925_c("display").func_150295_c("Lore", 8).add((Object)StringNBT.func_229705_a_((String)("{\"text\": \"" + lore + "\"}")));
    }

    private void setUnbreakable(boolean unbreakable) {
        if (unbreakable) {
            this.itemStack.func_196082_o().func_74757_a("Unbreakable", true);
        }
    }

    @Override
    protected AbstractProperty<String> createNewProperty(String initialValue, int index) {
        return new PropertyLore(index, initialValue, this::setLore);
    }

    @Override
    protected String getDefaultPropertyValue() {
        return "";
    }

    public class PropertyLore
    extends PropertyFormattedText
    implements IOrderableEditableCategoryProperty {
        private final IOrderableEditableCategoryProperty.OrderablePropertyControls controls;

        public PropertyLore(int index, String value, Consumer<String> action) {
            super("", value, action);
            this.controls = new IOrderableEditableCategoryProperty.OrderablePropertyControls(GeneralItemCategory.this, index);
            IOrderableEditableCategoryProperty.super.build();
        }

        @Override
        public IOrderableEditableCategoryProperty.OrderablePropertyControls getControls() {
            return this.controls;
        }

        @Override
        public void build() {
            super.build();
        }

        @Override
        public void update(int newIndex) {
            IOrderableEditableCategoryProperty.super.update(newIndex);
            this.nameLabel.setText("Lore #" + (newIndex + 1));
        }

        @Override
        public void updateSize(int listWidth) {
            this.textField.setPrefWidth(listWidth - 0 - 198);
        }
    }

    private static class Lore {
        private final String text;

        public Lore(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

