/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.CheckBox;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.NumericTextField;
import dlovin.inventoryhud.config.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ArmorConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton ViewBtn;
    private CustomButton BarsBtn;
    private CustomButton MoveAllBtn;
    private CustomButton ShowEmpty;
    private NumericTextField AboveField;
    private CustomButton ShowCountBtn;
    private CustomButton ScaleBtn;

    public ArmorConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 1, inGame);
    }

    @Override
    protected void init() {
        super.init();
        String toggle = InventoryHUD.getConfig().getArm() ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.AboveField = new NumericTextField(this.font, this.width / 2 + 20, 0, 40, 20, 0, 100, InventoryHUD.getConfig().getArmAbove(), tf -> this.AboveChanged());
        this.OptionList.addWidget(this.AboveField, 1);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 20, 0, 20, 20, this::TypeArmorChanged, InventoryHUD.getConfig().isShowArmor(), new class_2960("inventoryhud", "textures/gui/cb_arm.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 42, 0, 20, 20, this::TypeMainHandChanged, InventoryHUD.getConfig().isShowMain(), new class_2960("inventoryhud", "textures/gui/cb_mh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 64, 0, 20, 20, this::TypeOffHandChanged, InventoryHUD.getConfig().isShowOff(), new class_2960("inventoryhud", "textures/gui/cb_oh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 86, 0, 20, 20, this::TypeArrowChanged, InventoryHUD.getConfig().isShowArrows(), new class_2960("inventoryhud", "textures/gui/cb_ar.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 108, 0, 20, 20, this::TypeInvChanged, InventoryHUD.getConfig().isShowInv(), new class_2960("inventoryhud", "textures/gui/cb_inv.png")), 2);
        this.ViewBtn = new CustomButton(this.width / 2 + 20, 0, 75, 20, InventoryHUD.getConfig().getArmView().name(), null, false);
        this.OptionList.addWidget(this.ViewBtn, 3);
        this.ViewBtn.addListener(this::ViewSwitch);
        this.BarsBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getArmBars() + "", null, false);
        this.OptionList.addWidget(this.BarsBtn, 4);
        this.BarsBtn.addListener(this::BarsSwitch);
        this.MoveAllBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getMoveAll() + "", null, false);
        this.OptionList.addWidget(this.MoveAllBtn, 5);
        this.MoveAllBtn.addListener(this::MoveSwitch);
        this.ShowEmpty = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().isShowEmpty() + "", null, false);
        this.OptionList.addWidget(this.ShowEmpty, 6);
        this.ShowEmpty.addListener(this::EmptySwitch);
        this.ShowCountBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().isShowCount() + "", null, false);
        this.OptionList.addWidget(this.ShowCountBtn, 7);
        this.ShowCountBtn.addListener(this::ShowCountSwitch);
        float sc = (float)InventoryHUD.getConfig().getArmScale() / 100.0f;
        String t = sc + "x";
        this.ScaleBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, t, null, false);
        this.OptionList.addWidget(this.ScaleBtn, 8);
        this.ScaleBtn.addListener(this::ScaleSwitch);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_SCALE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_SCALE_TT.getString(), x, y)), 8);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_COUNT.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_COUNT_TT.getString(), x, y)), 7);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_EMPTY.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_EMPTY_TT.getString(), x, y)), 6);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_MOVE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_MOVE_TT.stream().map(class_2561::getString).collect(Collectors.toList()), x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_BARS.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_BARS_TT.getString(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_VIEW.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_VIEW_TT.stream().map(class_2561::getString).collect(Collectors.toList()), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TYPE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_TYPE_TT.getString(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_HIDE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_HIDE_TT.getString(), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TOGGLE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_TOGGLE_TT.getString(), x, y)), 0);
        this.AboveField.setMaxStringLength(5);
    }

    private void ScaleSwitch() {
        int scale = (InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale + 25) % 175;
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armScale = scale;
        InventoryHUD.getInstance().getInvhudGUI().changeArmorOffset();
        InventoryHUD.getConfig().setArmScale(scale);
        float sc = (float)scale / 100.0f;
        String t = sc + "x";
        this.ScaleBtn.setMessage(t);
    }

    private void ShowCountSwitch() {
        Boolean bd = !InventoryHUD.getConfig().isShowCount();
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showCount = bd;
        InventoryHUD.getConfig().setShowCount(bd);
        this.ShowCountBtn.setMessage(bd.toString());
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getConfig().setShowArmor(cb.checked);
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showMain = cb.checked;
        InventoryHUD.getConfig().setShowMain(cb.checked);
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showOff = cb.checked;
        InventoryHUD.getConfig().setShowOff(cb.checked);
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getConfig().setShowArrows(cb.checked);
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showInv = cb.checked;
        InventoryHUD.getConfig().setShowInv(cb.checked);
    }

    private void AboveChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AboveField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armAbove = a;
        InventoryHUD.getConfig().setArmAbove(a);
    }

    private void MoveSwitch() {
        Boolean bd = !InventoryHUD.getConfig().getMoveAll();
        InventoryHUD.getInstance().getInvhudGUI().changeMoveAll(bd);
        InventoryHUD.getConfig().setMoveAll(bd);
        this.MoveAllBtn.setMessage(bd.toString());
    }

    private void EmptySwitch() {
        Boolean bd = !InventoryHUD.getConfig().isShowEmpty();
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.showEmpty = bd;
        InventoryHUD.getConfig().setShowEmpty(bd);
        this.ShowEmpty.setMessage(bd.toString());
    }

    private void ViewSwitch() {
        InvConfig.ArmorView at = InventoryHUD.getConfig().getArmView();
        switch (at) {
            case PERCENTAGE: {
                at = InvConfig.ArmorView.DAMAGE;
                break;
            }
            case DAMAGE: {
                at = InvConfig.ArmorView.DAMAGE_LEFT;
                break;
            }
            case DAMAGE_LEFT: {
                at = InvConfig.ArmorView.OFF;
                break;
            }
            case OFF: {
                at = InvConfig.ArmorView.PERCENTAGE;
            }
        }
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armView = at;
        InventoryHUD.getConfig().setArmView(at);
        this.ViewBtn.setMessage(at.name());
    }

    private void ToggleSwitch() {
        Boolean armor = !InventoryHUD.getConfig().getArm();
        InventoryHUD.ArmHUD = armor;
        InventoryHUD.getConfig().setArm(armor);
        String armString = armor != false ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn.setMessage(armString);
    }

    private void BarsSwitch() {
        Boolean bars = !InventoryHUD.getConfig().getArmBars();
        InventoryHUD.getInstance().getInvhudGUI().armorRenderer.armBars = bars;
        InventoryHUD.getConfig().setArmBars(bars);
        this.BarsBtn.setMessage(bars.toString());
    }
}

