/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.gui;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.gui.ConfigScreen;
import dlovin.inventoryhud.config.widgets.CustomButton;
import dlovin.inventoryhud.config.widgets.NumericTextField;
import dlovin.inventoryhud.config.widgets.TextWidget;
import dlovin.inventoryhud.gui.InventoryHUDGui;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class InventoryConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton VerticalModeBtn;
    private NumericTextField AlphaField;
    private CustomButton AnimatedBtn;
    private CustomButton HideBGBtn;

    public InventoryConfigScreen(class_437 prev, boolean inGame) {
        super(prev, 0, inGame);
    }

    @Override
    protected void init() {
        super.init();
        String toggle = InventoryHUD.getConfig().getInv() ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.MiniModeBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getInvMini() + "", null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.MiniModeBtn.addListener(this::MiniModeSwitch);
        this.VerticalModeBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getInvVert() + "", null, false);
        this.OptionList.addWidget(this.VerticalModeBtn, 1);
        this.VerticalModeBtn.addListener(this::VerticalModeSwitch);
        this.AlphaField = new NumericTextField(this.font, this.width / 2 + 20, 0, 40, 20, 0, 100, InventoryHUD.getConfig().getInvAlpha(), tf -> this.AlphaChanged());
        this.OptionList.addWidget(this.AlphaField, 3);
        this.AnimatedBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().isInvAminated() + "", null, false);
        this.OptionList.addWidget(this.AnimatedBtn, 4);
        this.AnimatedBtn.addListener(this::AnimatedSwitch);
        this.HideBGBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().isInvHideBG() + "", null, false);
        this.OptionList.addWidget(this.HideBGBtn, 5);
        this.HideBGBtn.addListener(this::HideBGSwitch);
        this.AlphaField.setMaxStringLength(5);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_HIDEBG.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_HIDEBG_TT.getString(), x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ANIMATED.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_ANIMATED_TT.getString(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ALPHA.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_ALPHA_TT.getString(), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_MINI.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_MINI_TT.getString(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_VERT.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_VERT_TT.stream().map(class_2561::getString).collect(Collectors.toList()), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_TOGGLE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.INV_TOGGLE_TT.getString(), x, y)), 0);
    }

    private void AnimatedSwitch() {
        Boolean mm = !InventoryHUD.getConfig().isInvAminated();
        InventoryHUDGui.invAnimated = mm;
        InventoryHUD.getConfig().setInvAminated(mm);
        this.AnimatedBtn.setMessage(mm.toString());
    }

    private void HideBGSwitch() {
        Boolean mm = !InventoryHUD.getConfig().isInvHideBG();
        InventoryHUDGui.invHideBG = mm;
        InventoryHUD.getConfig().setInvHideBG(mm);
        this.HideBGBtn.setMessage(mm.toString());
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUDGui.invAlpha = (float)a / 100.0f;
        InventoryHUD.getConfig().setInvAlpha(a);
    }

    private void MiniModeSwitch() {
        Boolean mm = !InventoryHUD.getConfig().getInvMini();
        InventoryHUDGui.invMini = mm;
        InventoryHUD.getConfig().setInvMini(mm);
        this.MiniModeBtn.setMessage(mm.toString());
    }

    private void VerticalModeSwitch() {
        Boolean vm = !InventoryHUD.getConfig().getInvVert();
        InventoryHUDGui.invVert = vm;
        InventoryHUD.getConfig().setInvVert(vm);
        this.VerticalModeBtn.setMessage(vm.toString());
    }

    private void ToggleSwitch() {
        Boolean bd = !InventoryHUD.getConfig().getInv();
        InventoryHUD.InvHUD = bd;
        InventoryHUD.getConfig().setInv(bd);
        String toggle = bd != false ? class_124.field_1077 + "ON" : class_124.field_1079 + "OFF";
        this.ToggleBtn.setMessage(toggle);
    }
}

