/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.PotionRenderer;
import java.util.Collection;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4074;
import net.minecraft.class_4587;

public class HorizontalPotionRenderer
extends PotionRenderer {
    private final class_2960 PBG = new class_2960("inventoryhud", "textures/gui/potion_bg_hor.png");

    public HorizontalPotionRenderer(class_310 mc) {
        super(mc);
    }

    private int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 18 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 18 - (effCount - 1) * (36 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 18) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 18.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 36);
            }
        }
        return result;
    }

    private int getY(int height) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 18 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    public void render(class_4587 mat, int width, int height) {
        int x = 0;
        Collection collection = this.mc.field_1724.method_6026();
        if (collection.isEmpty()) {
            return;
        }
        int effCount = collection.size();
        class_4074 statusEffectSpriteManager = this.mc.method_18505();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        int xPos = this.getX(width, effCount);
        int yPos = this.getY(height);
        for (class_1293 statusEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            class_1291 statusEffect = statusEffectInstance.method_5579();
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            this.mc.method_1531().method_22813(this.PBG);
            this.blit(mat, xPos + x, yPos, 36.0f, 38.0f, 36, 38, 36, 38);
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_1058 sprite = statusEffectSpriteManager.method_18663(statusEffect);
            this.mc.method_1531().method_22813(sprite.method_24119().method_24106());
            HorizontalPotionRenderer.method_25298((class_4587)mat, (int)(xPos + x + 9), (int)(yPos + 3), (int)0, (int)18, (int)18, (class_1058)sprite);
            class_2960 lev = statusEffectInstance.method_5578() < 9 && statusEffectInstance.method_5578() >= 0 ? new class_2960("inventoryhud", "textures/gui/l_" + statusEffectInstance.method_5578() + ".png") : new class_2960("inventoryhud", "textures/gui/l_inf.png");
            this.mc.method_1531().method_22813(lev);
            this.blit(mat, xPos + x + 21, yPos, 9.0f, 9.0f, 9, 9, 9, 9);
            String time = "";
            int dur = statusEffectInstance.method_5584() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = dur / 60 + "";
                String secs = dur % 60 + "";
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : class_124.field_1061 + mins + class_124.field_1068 + ":" + class_124.field_1061 + secs;
            }
            this.fontRenderer.method_1720(mat, time, (float)(xPos + x + 5), (float)(yPos + 25), 0xFFFFFF);
            x += 36 + this.potGap;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

