/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.ArmorRenderer;
import dlovin.inventoryhud.utils.ArmorStatus;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class HotBarArmorRenderer
extends ArmorRenderer {
    private List<RenderItemHandler> handlers = new ArrayList<RenderItemHandler>();
    private int[] armorPosX = new int[]{-96, -96, 96, 96, 96, -96};
    private final int[] armorPosY = new int[]{56, 38, 56, 38, 74, 74, 20, 20};

    public HotBarArmorRenderer(class_310 mc) {
        super(mc);
    }

    @Override
    public void render(class_4587 mat, int width, int height) {
        int i = 5;
        float scale = (float)this.armScale / 100.0f;
        int iconOff = (int)(-16.0f * scale);
        boolean hr = this.mc.field_1724.method_6068().equals((Object)class_1306.field_6183);
        boolean emptyOff = this.mc.field_1724.field_7514.field_7544.stream().allMatch(class_1799::method_7960);
        Object[] leftX = this.getLeftX(width, scale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] rightX = this.getRightX(width, scale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        for (class_1799 item : this.mc.field_1724.method_5743()) {
            Object[] curX;
            int yOff = 0;
            if (!this.showArmor) {
                if (i < 4) {
                    --i;
                    continue;
                }
                yOff = 36;
            }
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            int Damage = ArmorStatus.GetDamage(item);
            boolean rght = i < 2 || i > 4;
            Object[] objectArray = curX = rght ? (Object[])leftX.clone() : (Object[])rightX.clone();
            if (scale >= 1.0f) {
                int xOff;
                if (this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    rght = !rght;
                }
                int n = xOff = i > 1 && i < 5 ? 0 : iconOff;
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    xOff = i > 1 && i < 5 ? (xOff += (int)(24.0f * scale)) : (xOff += (int)(-24.0f * scale));
                }
                curX[0] = width / 2 + this.armorPosX[i] + xOff;
                curX[1] = rght;
            }
            String text = null;
            boolean over = true;
            if (Damage >= 0 && Damage <= this.armAbove) {
                over = this.armBars;
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (this.armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(item.method_7919()), Damage);
                            break;
                        }
                        case DAMAGE_LEFT: {
                            text = this.getDamageText(String.valueOf(item.method_7936() - item.method_7919()), Damage);
                        }
                    }
                }
                this.pushAndRender(mat, (Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], null, item, text, over, scale);
            } else if (Damage == -2) {
                over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    text = "" + this.getItemCount(item);
                    over = false;
                }
                this.pushAndRender(mat, (Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], null, item, text, over, scale);
            } else if (this.showEmpty) {
                this.pushAndRender(mat, (Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], this.armorRL[i], null, null, false, scale);
            }
            --i;
        }
        if (this.showInv || this.showArrows) {
            int count = 0;
            int arrows = 0;
            for (class_1799 slot : this.mc.field_1724.field_7514.field_7547) {
                if (slot.method_7960()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.method_7947();
            }
            if (this.showArrows) {
                this.pushAndRender(mat, (Integer)leftX[0], (int)((float)height - (float)this.armorPosY[7] * scale), (Boolean)leftX[1], this.armorRL[7], null, arrows + "", false, scale);
            }
            if (this.showInv) {
                this.pushAndRender(mat, (Integer)rightX[0], (int)((float)height - (float)this.armorPosY[7] * scale), (Boolean)rightX[1], this.armorRL[6], null, count + "", false, scale);
            }
        }
        RenderSystem.popMatrix();
    }

    private Object[] getRightX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int offset = !avOff || !empty && !hRight ? (!empty && !hRight && scale < 1.0f ? 26 : (int)(24.0f * scale)) : 0;
        boolean right = avOff || !hRight && !empty;
        return new Object[]{width / 2 + 96 + offset, right};
    }

    private Object[] getLeftX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int iconOffset = (int)(-16.0f * scale);
        int offset = !avOff || !empty && hRight ? (!empty && hRight && scale < 1.0f ? -26 : (int)(-24.0f * scale)) : 0;
        boolean right = !avOff && (!hRight || empty);
        return new Object[]{width / 2 - 96 + iconOffset + offset, right};
    }

    private void pushAndRender(class_4587 mat, int x, int y, boolean right, class_2960 resourceLocation, class_1799 itemStack, String text, boolean over, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        this.renderElement(mat, 0, 0, right, resourceLocation, itemStack, text, over);
        RenderSystem.popMatrix();
    }

    public static interface RenderItemHandler {
        public void render(class_4587 var1, int var2, int var3, boolean var4, class_2960 var5, class_1799 var6, String var7, boolean var8, float var9);
    }
}

