/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.ArmorRenderer;
import dlovin.inventoryhud.gui.BlockArmorRenderer;
import dlovin.inventoryhud.gui.EachArmorRenderer;
import dlovin.inventoryhud.gui.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.PotionRenderer;
import dlovin.inventoryhud.gui.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_918;

public class InventoryHUDGui {
    private static class_310 mc;
    private static class_918 ir;
    private static class_327 tr;
    private static final class_2960 INVBG;
    public static WidgetAligns InvAligns;
    public static int invX;
    public static int invY;
    public static boolean invMini;
    public static boolean invVert;
    public static float invAlpha;
    public static boolean invHideBG;
    public static boolean invAnimated;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;

    public InventoryHUDGui() {
        mc = class_310.method_1551();
        ir = mc.method_1480();
        tr = InventoryHUDGui.mc.field_1772;
        this.InitializeStatic();
        WidgetAligns ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        int armX = InventoryHUD.getConfig().getArmX();
        int armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer = !InventoryHUD.getConfig().getMoveAll() ? new EachArmorRenderer(mc) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(mc) : new BlockArmorRenderer(mc));
        this.setupArmorRenderer();
        this.potionRenderer = InventoryHUD.getConfig().isPotHor() ? (InventoryHUD.getConfig().getPotMini() ? new HorizontalMiniPotionRenderer(mc) : new HorizontalPotionRenderer(mc)) : (InventoryHUD.getConfig().getPotMini() ? new VerticalMiniPotionRenderer(mc) : new VerticalPotionRenderer(mc));
        this.setupPotionRenderer();
        System.out.println("InvGUI Initialized");
    }

    private void InitializeStatic() {
        invX = InventoryHUD.getConfig().getInvX();
        invY = InventoryHUD.getConfig().getInvY();
        InvAligns = new WidgetAligns(InventoryHUD.getConfig().getInvHal(), InventoryHUD.getConfig().getInvVal());
        invMini = InventoryHUD.getConfig().getInvMini();
        invVert = InventoryHUD.getConfig().getInvVert();
        invAlpha = (float)InventoryHUD.getConfig().getInvAlpha() / 100.0f;
        invHideBG = InventoryHUD.getConfig().isInvHideBG();
        invAnimated = InventoryHUD.getConfig().isInvAminated();
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = InventoryHUD.getConfig().getArmX();
        this.armorRenderer.armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer.ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        this.armorRenderer.armAbove = InventoryHUD.getConfig().getArmAbove();
        this.armorRenderer.armScale = InventoryHUD.getConfig().getArmScale();
        this.armorRenderer.showArmor = InventoryHUD.getConfig().isShowArmor();
        this.armorRenderer.showMain = InventoryHUD.getConfig().isShowMain();
        this.armorRenderer.showOff = InventoryHUD.getConfig().isShowOff();
        this.armorRenderer.showArrows = InventoryHUD.getConfig().isShowArrows();
        this.armorRenderer.showInv = InventoryHUD.getConfig().isShowInv();
        this.armorRenderer.showEmpty = InventoryHUD.getConfig().isShowEmpty();
        this.armorRenderer.showCount = InventoryHUD.getConfig().isShowCount();
        this.armorRenderer.armView = InventoryHUD.getConfig().getArmView();
        this.armorRenderer.armBars = InventoryHUD.getConfig().getArmBars();
        this.armorRenderer.items[0] = new EachItem(InventoryHUD.getConfig().getHelmX(), InventoryHUD.getConfig().getHelmY(), new WidgetAligns(InventoryHUD.getConfig().getHelmHal(), InventoryHUD.getConfig().getHelmVal()));
        this.armorRenderer.items[1] = new EachItem(InventoryHUD.getConfig().getChestX(), InventoryHUD.getConfig().getChestY(), new WidgetAligns(InventoryHUD.getConfig().getChestHal(), InventoryHUD.getConfig().getChestVal()));
        this.armorRenderer.items[2] = new EachItem(InventoryHUD.getConfig().getLegX(), InventoryHUD.getConfig().getLegY(), new WidgetAligns(InventoryHUD.getConfig().getLegHal(), InventoryHUD.getConfig().getLegVal()));
        this.armorRenderer.items[3] = new EachItem(InventoryHUD.getConfig().getBootsX(), InventoryHUD.getConfig().getBootsY(), new WidgetAligns(InventoryHUD.getConfig().getBootsHal(), InventoryHUD.getConfig().getBootsVal()));
        this.armorRenderer.items[4] = new EachItem(InventoryHUD.getConfig().getOffX(), InventoryHUD.getConfig().getOffY(), new WidgetAligns(InventoryHUD.getConfig().getOffHal(), InventoryHUD.getConfig().getOffVal()));
        this.armorRenderer.items[5] = new EachItem(InventoryHUD.getConfig().getMainX(), InventoryHUD.getConfig().getMainY(), new WidgetAligns(InventoryHUD.getConfig().getMainHal(), InventoryHUD.getConfig().getMainVal()));
        this.armorRenderer.items[6] = new EachItem(InventoryHUD.getConfig().getInvIconX(), InventoryHUD.getConfig().getInvIconY(), new WidgetAligns(InventoryHUD.getConfig().getInvIconHal(), InventoryHUD.getConfig().getInvIconVal()));
        this.armorRenderer.items[7] = new EachItem(InventoryHUD.getConfig().getArrX(), InventoryHUD.getConfig().getArrY(), new WidgetAligns(InventoryHUD.getConfig().getArrHal(), InventoryHUD.getConfig().getArrVal()));
        this.changeArmorOffset();
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = InventoryHUD.getConfig().getPotX();
        this.potionRenderer.potY = InventoryHUD.getConfig().getPotY();
        this.potionRenderer.PotAligns = new WidgetAligns(InventoryHUD.getConfig().getPotHal(), InventoryHUD.getConfig().getPotVal());
        this.potionRenderer.potMini = InventoryHUD.getConfig().getPotMini();
        this.potionRenderer.potGap = InventoryHUD.getConfig().getPotGap();
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < mc.method_22683().method_4502() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)InventoryHUD.getConfig().getPotAlpha() / 100.0f;
    }

    public void render(float tickDelta) {
        class_1041 mainWindow = mc.method_22683();
        int width = mainWindow.method_4486();
        int height = mainWindow.method_4502();
        if (InventoryHUD.PotHUD) {
            this.potionRenderer.render(new class_4587(), width, height);
        }
        if (InventoryHUD.ArmHUD) {
            this.armorRenderer.render(new class_4587(), width, height);
        }
        if (InventoryHUDGui.mc.field_1755 instanceof class_465) {
            return;
        }
        if (InventoryHUD.InvHUD) {
            this.renderInventory(width, height, tickDelta);
        }
    }

    private void renderInventory(int width, int height, float partialTicks) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        double scale = invMini ? 0.75 : 1.0;
        int px = this.getX(width, (int)((double)(iMax * 18 - 2) * scale), invX, InventoryHUDGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((double)(jMax * 18 - 2) * scale), invY, InventoryHUDGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                class_1799 item = (class_1799)InventoryHUDGui.mc.field_1724.field_7514.field_7547.get(index);
                if (item == null || item.method_7909().equals(class_1802.field_8162)) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.method_7965() - partialTicks;
                    if (invAnimated && f > 0.0f) {
                        RenderSystem.pushMatrix();
                        float f1 = 1.0f + f / 5.0f;
                        RenderSystem.translatef((float)(finalI * 18 + 12), (float)(finalJ * 18 + 12), (float)0.0f);
                        RenderSystem.scalef((float)((f1 + 1.0f) / 2.0f), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                        RenderSystem.translatef((float)(-(finalI * 18 + 12)), (float)(-(finalJ * 18 + 12)), (float)0.0f);
                    }
                    ir.method_4010(item, finalI * 18, finalJ * 18);
                    if (invAnimated && f > 0.0f) {
                        RenderSystem.popMatrix();
                    }
                    ir.method_4022(tr, item, finalI * 18, finalJ * 18, null);
                });
            }
        }
        if (invHideBG && items.size() == 0) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)px, (double)py, (double)-255.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
        mc.method_1531().method_22813(INVBG);
        class_332.method_25293((class_4587)new class_4587(), (int)-8, (int)-8, (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (int)256, (int)256);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        items.forEach(r -> r.run());
        RenderSystem.popMatrix();
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = x;
                break;
            }
            case MIDDLE: {
                result = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = 0;
        switch (val) {
            case TOP: {
                result = y;
                break;
            }
            case CENTER: {
                result = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns(InventoryHUD.getConfig().getArmHal(), InventoryHUD.getConfig().getArmVal());
        int armX = InventoryHUD.getConfig().getArmX();
        int armY = InventoryHUD.getConfig().getArmY();
        this.armorRenderer = bd == false ? new EachArmorRenderer(mc) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(mc) : new BlockArmorRenderer(mc));
        this.setupArmorRenderer();
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        float scale = (float)this.armorRenderer.armScale / 100.0f;
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * scale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(mc);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(mc);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, InventoryHUD.getConfig().isPotHor());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion(InventoryHUD.getConfig().getPotMini(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(mc) : new HorizontalPotionRenderer(mc)) : (mini ? new VerticalMiniPotionRenderer(mc) : new VerticalPotionRenderer(mc));
        this.setupPotionRenderer();
    }

    static {
        INVBG = new class_2960("inventoryhud", "textures/gui/inv_bg.png");
    }
}

