/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.PotionRenderer;
import java.util.Collection;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4074;
import net.minecraft.class_4587;

public class VerticalMiniPotionRenderer
extends PotionRenderer {
    private final class_2960 PBG = new class_2960("inventoryhud", "textures/gui/potion_bg_mini.png");

    public VerticalMiniPotionRenderer(class_310 mc) {
        super(mc);
    }

    private int getX(int width) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 22 - this.potX;
                    break;
                }
                result = width / 2 - 11 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX + 23;
            }
        }
        return result;
    }

    private int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 9 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 9 - (effCount - 1) * (18 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 18);
            }
        }
        return result;
    }

    @Override
    public void render(class_4587 mat, int width, int height) {
        int y = 0;
        Collection collection = this.mc.field_1724.method_6026();
        if (collection.isEmpty()) {
            return;
        }
        int effCount = collection.size();
        class_4074 statusEffectSpriteManager = this.mc.method_18505();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        int xPos = this.getX(width);
        int yPos = this.getY(height, effCount);
        for (class_1293 statusEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            class_1291 statusEffect = statusEffectInstance.method_5579();
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            this.mc.method_1531().method_22813(this.PBG);
            this.blit(mat, xPos, yPos + y, 22.0f, 18.0f, 22, 18, 22 * this.potSide, 18);
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_1058 sprite = statusEffectSpriteManager.method_18663(statusEffect);
            this.mc.method_1531().method_22813(sprite.method_24119().method_24106());
            VerticalMiniPotionRenderer.method_25298((class_4587)mat, (int)(xPos + 3 + this.potIconSide), (int)(yPos + y + 3), (int)0, (int)12, (int)12, (class_1058)sprite);
            class_2960 lev = statusEffectInstance.method_5578() < 9 && statusEffectInstance.method_5578() >= 0 ? new class_2960("inventoryhud", "textures/gui/l_" + statusEffectInstance.method_5578() + ".png") : new class_2960("inventoryhud", "textures/gui/l_inf.png");
            this.mc.method_1531().method_22813(lev);
            this.blit(mat, xPos + 9 + this.potIconSide, yPos + y, 9.0f, 9.0f, 9, 9, 9, 9);
            int dur = statusEffectInstance.method_5584() / 20;
            int ysize = 12;
            this.mc.method_1531().method_22813(this.PMT);
            RenderSystem.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (dur < 300) {
                float r = 1.0f;
                float g = 1.0f;
                ysize = dur / 25 + 1;
                if (dur < 150) {
                    g = 0.006666667f * (float)dur;
                } else {
                    r = 0.006666667f * (float)(300 - dur);
                }
                RenderSystem.color4f((float)r, (float)g, (float)0.0f, (float)1.0f);
            }
            this.blit(mat, xPos + 17 + this.potTextSide, yPos + y + 15 - ysize, 3.0f, ysize, 3, ysize, 3, ysize);
            y += 18 + this.potGap;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

