/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.InvEvents;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventoryhud")
public class InventoryHUD {
    private static InventoryHUD instance;
    private InventoryGui inventoryGui;
    public static final String modid = "inventoryhud";
    public static final Logger logger;
    private static InvConfig CONFIG;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;

    public InventoryHUD() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        CONFIG = new InvConfig();
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::clientRegistries);
        CONFIG.register(ModLoadingContext.get());
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> this::openSettings);
        isActive = (Boolean)InventoryHUD.CONFIG.getClient().byDefault.get();
        armorHUD = (Boolean)InventoryHUD.CONFIG.getClient().ArmorDamage.get();
        potionHUD = (Boolean)InventoryHUD.CONFIG.getClient().Potions.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openSettings(Minecraft mc, Screen modlist) {
        return new InventoryConfigScreen(false);
    }

    public static InvConfig getConfig() {
        return CONFIG;
    }

    public static InvConfig.Client getClient() {
        return CONFIG.getClient();
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        this.inventoryGui = new InventoryGui();
        MinecraftForge.EVENT_BUS.register((Object)this.inventoryGui);
        MinecraftForge.EVENT_BUS.register((Object)new InvEvents());
        logger.info("clientRegistries method registred");
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    static {
        logger = LogManager.getLogger((String)modid);
        isActive = false;
        armorHUD = false;
        potionHUD = true;
    }
}

