/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;

public class HotBarArmorRenderer
extends ArmorRenderer {
    private int[] armorPosX = new int[]{-96, -96, 96, 96, 96, -96};
    private final int[] armorPosY = new int[]{56, 38, 56, 38, 74, 74, 20, 20};

    public HotBarArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(int width, int height) {
        int i = 5;
        float scale = (float)this.armScale / 100.0f;
        int iconOff = (int)(-16.0f * scale);
        boolean hr = this.mc.field_71439_g.func_184591_cq().equals((Object)HandSide.RIGHT);
        boolean emptyOff = this.mc.field_71439_g.field_71071_by.field_184439_c.stream().allMatch(ItemStack::func_190926_b);
        Object[] leftX = this.getLeftX(width, scale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] rightX = this.getRightX(width, scale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.0, (double)-255.0);
        for (ItemStack item : this.mc.field_71439_g.func_184209_aF()) {
            Object[] curX;
            int yOff = 0;
            if (!this.showArmor) {
                if (i < 4) {
                    --i;
                    continue;
                }
                yOff = 36;
            }
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            int Damage = ArmorStatus.GetDamage(item);
            boolean rght = i < 2 || i > 4;
            Object[] objectArray = curX = rght ? (Object[])leftX.clone() : (Object[])rightX.clone();
            if (scale >= 1.0f) {
                int xOff;
                if (this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    rght = !rght;
                }
                int n = xOff = i > 1 && i < 5 ? 0 : iconOff;
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    xOff = i > 1 && i < 5 ? (xOff += (int)(24.0f * scale)) : (xOff += (int)(-24.0f * scale));
                }
                curX[0] = width / 2 + this.armorPosX[i] + xOff;
                curX[1] = rght;
            }
            String text = null;
            boolean over = true;
            if (Damage >= 0 && Damage <= this.armAbove) {
                over = this.armBars;
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (this.armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(item.func_77952_i()), Damage);
                            break;
                        }
                        case DAMAGE_LEFT: {
                            text = this.getDamageText(String.valueOf(item.func_77958_k() - item.func_77952_i()), Damage);
                        }
                    }
                }
                this.pushAndRender((Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], null, item, text, over, scale);
            } else if (Damage == -2) {
                over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    text = "" + this.getItemCount(item);
                    over = false;
                }
                this.pushAndRender((Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], null, item, text, over, scale);
            } else if (this.showEmpty) {
                this.pushAndRender((Integer)curX[0], (int)((float)height - (float)(this.armorPosY[i] - yOff) * scale), (Boolean)curX[1], this.armorRL[i], null, null, false, scale);
            }
            --i;
        }
        if (this.showInv || this.showArrows) {
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.mc.field_71439_g.field_71071_by.field_70462_a) {
                if (slot.func_190926_b()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.func_190916_E();
            }
            if (this.showArrows) {
                this.pushAndRender((Integer)leftX[0], (int)((float)height - (float)this.armorPosY[7] * scale), (Boolean)leftX[1], this.armorRL[7], null, arrows + "", false, scale);
            }
            if (this.showInv) {
                this.pushAndRender((Integer)rightX[0], (int)((float)height - (float)this.armorPosY[7] * scale), (Boolean)rightX[1], this.armorRL[6], null, count + "", false, scale);
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    private Object[] getRightX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int offset = !avOff || !empty && !hRight ? (!empty && !hRight && scale < 1.0f ? 26 : (int)(24.0f * scale)) : 0;
        boolean right = avOff || !hRight && !empty;
        return new Object[]{width / 2 + 96 + offset, right};
    }

    private Object[] getLeftX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int iconOffset = (int)(-16.0f * scale);
        int offset = !avOff || !empty && hRight ? (!empty && hRight && scale < 1.0f ? -26 : (int)(-24.0f * scale)) : 0;
        boolean right = !avOff && (!hRight || empty);
        return new Object[]{width / 2 - 96 + iconOffset + offset, right};
    }

    private void pushAndRender(int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        this.renderElement(0, 0, right, resourceLocation, itemStack, text, over);
        GlStateManager.popMatrix();
    }
}

