/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;

public class VerticalMiniPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini.png");

    public VerticalMiniPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 22 - this.potX;
                    break;
                }
                result = width / 2 - 11 - this.potX;
                break;
            }
            case RIGHT: {
                result = width - this.potX + 23;
            }
        }
        return result;
    }

    private int getY(int height, int effCount) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    result = height / 2 - 9 - this.potY;
                    break;
                }
                if (this.potY < 0) {
                    result = height / 2 - 9 - (effCount - 1) * (18 + this.potGap) - this.potY;
                    break;
                }
                result = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 9.0f) - (float)this.potY);
                break;
            }
            case BOTTOM: {
                result = height - this.potY - (effCount - 1) * (this.potGap + 18);
            }
        }
        return result;
    }

    @Override
    public void render(int width, int height) {
        int y = 0;
        int effCount = this.mc.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        PotionSpriteUploader potionspriteuploader = this.mc.func_213248_ap();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.0, (double)-255.0);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        int xPos = this.getX(width);
        int yPos = this.getY(height, effCount);
        for (EffectInstance effect : this.mc.field_71439_g.func_70651_bq()) {
            Effect pot = effect.func_188419_a();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            this.mc.func_110434_K().func_110577_a(this.PBG);
            VerticalMiniPotionRenderer.blit((int)xPos, (int)(yPos + y), (float)22.0f, (float)18.0f, (int)22, (int)18, (int)(22 * this.potSide), (int)18);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(pot);
            this.mc.func_110434_K().func_110577_a(AtlasTexture.field_215264_i);
            VerticalMiniPotionRenderer.blit((int)(xPos + 3 + this.potIconSide), (int)(yPos + y + 3), (int)this.blitOffset, (int)12, (int)12, (TextureAtlasSprite)textureatlassprite);
            ResourceLocation lev = effect.func_76458_c() < 9 && effect.func_76458_c() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.mc.func_110434_K().func_110577_a(lev);
            VerticalMiniPotionRenderer.blit((int)(xPos + 9 + this.potIconSide), (int)(yPos + y), (float)9.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)9);
            int dur = effect.func_76459_b() / 20;
            int ysize = 12;
            this.mc.func_110434_K().func_110577_a(this.PMT);
            GlStateManager.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (dur < 300) {
                float r = 1.0f;
                float g = 1.0f;
                ysize = dur / 25 + 1;
                if (dur < 150) {
                    g = 0.006666667f * (float)dur;
                } else {
                    r = 0.006666667f * (float)(300 - dur);
                }
                GlStateManager.color4f((float)r, (float)g, (float)0.0f, (float)1.0f);
            }
            VerticalMiniPotionRenderer.blit((int)(xPos + 17 + this.potTextSide), (int)(yPos + y + 15 - ysize), (float)3.0f, (float)ysize, (int)3, (int)ysize, (int)3, (int)ysize);
            y += 18 + this.potGap;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }
}

