/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.ResourceLocation;

public class CustomOptionList
extends AbstractOptionList {
    private static final int ITEM_HEIGHT = 30;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final Screen parent;
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final ResourceLocation SCROLL = new ResourceLocation("inventoryhud", "textures/gui/scroll.png");

    public CustomOptionList(Minecraft p_i51130_1_, Screen screen) {
        super(p_i51130_1_, screen.width, screen.height, 55, screen.height - 32, 30);
        this.parent = screen;
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.y0 + 10 + 30 * row + widget.y;
        this.widgets.add(widget);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public boolean mouseScrolled(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        double tmp = 0.0;
        if (this.maxHeight > this.y1 - this.y0) {
            tmp = p_231043_5_ * 5.0;
            int diff = this.maxHeight - (this.y1 - this.y0);
            this.scroll = (int)((double)this.scroll - tmp);
            if (this.scroll < 0) {
                tmp += (double)this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp += (double)(this.scroll - diff);
                this.scroll = diff;
            }
        }
        for (Widget w : this.widgets) {
            if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                ((NumericTextField)w).setFocused2(false);
            }
            w.y = (int)((double)w.y + tmp);
        }
        return true;
    }

    public boolean mouseDragged(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.isDragging) {
            int height = this.y1 - this.y0;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += p_231045_8_ / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.y1 - this.y0);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            for (Widget w : this.widgets) {
                if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                    ((NumericTextField)w).setFocused2(false);
                }
                w.y -= tmp;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.isMouseOver(p_231044_1_, p_231044_3_)) {
            return false;
        }
        if (this.maxHeight > this.y1 - this.y0 && p_231044_5_ == 0) {
            int pos = this.width > 309 ? this.width / 2 + 150 : this.width - 9;
            int height = this.y1 - this.y0;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.y0 + (int)((double)this.scroll * scale);
            if (this.isOver(p_231044_1_, p_231044_3_, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.isDragging = true;
            }
        }
        for (Widget w : this.widgets) {
            if (!w.hovered && !(w instanceof NumericTextField)) continue;
            w.mouseClicked(p_231044_1_, p_231044_3_, p_231044_5_);
        }
        return false;
    }

    public boolean mouseReleased(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        this.isDragging = false;
        return false;
    }

    public boolean charTyped(char p_231042_1_, int p_231042_2_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
            w.charTyped(p_231042_1_, p_231042_2_);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused()) continue;
            w.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
            return true;
        }
        super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(int xPos, int height) {
        CustomOptionList.blit((int)xPos, (int)this.y0, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)this.y0, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)xPos, (int)(this.y1 - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)(this.y1 - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)this.y0, (int)3, (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)(this.y0 + 3), (int)3, (int)(height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)(this.y1 - 3), (int)3, (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)xPos, (int)(this.y0 + 3), (int)3, (int)(height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)(this.y0 + 3), (int)3, (int)(height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private void renderScroll(int xPos, int height, int pos) {
        CustomOptionList.blit((int)xPos, (int)pos, (int)3, (int)3, (float)16.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)pos, (int)3, (int)3, (float)29.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)xPos, (int)(-3 + height + pos), (int)3, (int)3, (float)16.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)(-3 + height + pos), (int)3, (int)3, (float)29.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)pos, (int)3, (int)3, (float)19.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 6), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)29.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)(-3 + height + pos), (int)3, (int)3, (float)19.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.blit((int)xPos, (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)16.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.blit((int)(xPos + 3), (int)(3 + pos), (int)3, (int)(height - 6 > 0 ? height - 6 : 0), (float)19.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void renderList(int p_238478_2_, int p_238478_3_, int p_238478_4_, int p_238478_5_, float p_238478_6_) {
        if (this.maxHeight > this.y1 - this.y0) {
            int pos = this.width > 309 ? this.width / 2 + 150 : this.width - 9;
            this.minecraft.func_110434_K().func_110577_a(this.SCROLL);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            int height = this.y1 - this.y0;
            this.renderScrollBG(pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.y0 + (int)((double)this.scroll * scale);
            GlStateManager.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(p_238478_4_, p_238478_5_, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(pos, height, yPos);
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Widget w : this.widgets) {
            w.render(p_238478_4_, p_238478_5_, p_238478_6_);
        }
    }

    public void renderTooltips(int x, int y) {
        if (x < this.x0 || x > this.x1 || y < this.y0 || y > this.y1) {
            return;
        }
        for (Widget w : this.widgets) {
            w.renderTooltip(x, y);
        }
    }
}

