/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NumericTextField
extends Widget {
    protected final IPressable onChange;
    private final FontRenderer fontRenderer;
    private String text;
    private int maxStringLength = 32;
    private final boolean enableBackgroundDrawing = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    private boolean field_212956_h;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private final int minValue;
    private final int maxValue;
    private final int defValue;
    private String prevText;
    private final ResourceLocation BG = new ResourceLocation("inventoryhud", "textures/gui/tf_bg.png");
    private Predicate<String> validator = Predicates.alwaysTrue();
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;

    public NumericTextField(FontRenderer p_i232260_1_, int p_i232260_2_, int p_i232260_3_, int p_i232260_4_, int p_i232260_5_, int minValue, int maxValue, int defValue, IPressable onChange) {
        super(p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, defValue + "");
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defValue = defValue;
        this.text = this.prevText = defValue + "";
        this.fontRenderer = p_i232260_1_;
        this.onChange = onChange;
    }

    protected String getNarrationMessage() {
        String s = this.getMessage();
        return s.isEmpty() ? "" : I18n.func_135052_a((String)"gui.narrate.editBox", (Object[])new Object[]{s, this.text});
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        String s1;
        int l;
        int i;
        block7: {
            String s;
            i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
            int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
            int k = this.maxStringLength - this.text.length() - (i - j);
            if (k < (l = (s = SharedConstants.func_71565_a((String)textToWrite)).length())) {
                s = s.substring(0, k);
                l = k;
            }
            s1 = new StringBuilder(this.text).replace(i, j, s).toString();
            try {
                int num = Integer.parseInt(s1);
                s1 = num + "";
                if (num < this.minValue) {
                    s1 = this.minValue + "";
                } else if (num > this.maxValue) {
                    s1 = this.maxValue + "";
                }
            }
            catch (NumberFormatException ex) {
                if (s.equalsIgnoreCase("-")) break block7;
                s1 = this.prevText;
            }
        }
        if (this.validator.test(s1)) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (!newText.equals(this.prevText) && this.isNumeric(newText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    private void delete(int p_212950_1_) {
        if (Screen.hasControlDown()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.func_238516_r_(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.func_238516_r_(num));
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.field_212956_h) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    private int func_238516_r_(int p_238516_1_) {
        return NumericTextField.func_240980_a_(this.text, this.cursorPosition, p_238516_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_240980_a_(String p_240980_0_, int p_240980_1_, int p_240980_2_) {
        int i = p_240980_0_.length();
        if (p_240980_2_ >= 0) {
            for (int j = 0; p_240980_1_ < i && j < p_240980_2_; ++j) {
                if (!Character.isHighSurrogate(p_240980_0_.charAt(p_240980_1_++)) || p_240980_1_ >= i || !Character.isLowSurrogate(p_240980_0_.charAt(p_240980_1_))) continue;
                ++p_240980_1_;
            }
        } else {
            for (int k = p_240980_2_; p_240980_1_ > 0 && k < 0; ++k) {
                if (!Character.isLowSurrogate(p_240980_0_.charAt(--p_240980_1_)) || p_240980_1_ <= 0 || !Character.isHighSurrogate(p_240980_0_.charAt(p_240980_1_ - 1))) continue;
                --p_240980_1_;
            }
        }
        return p_240980_1_;
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.field_212956_h = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)p_231046_1_)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.isCopy((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.isPaste((int)p_231046_1_)) {
            if (this.isEnabled && this.isNumeric(Minecraft.func_71410_x().field_195559_v.func_197965_a())) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.isCut((int)p_231046_1_)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.isEnabled) {
                this.writeText("");
            }
            return true;
        }
        switch (p_231046_1_) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                if (this.isEnabled) {
                    this.field_212956_h = false;
                    this.delete(-1);
                    this.field_212956_h = Screen.hasShiftDown();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEnabled) {
                    this.field_212956_h = false;
                    this.delete(1);
                    this.field_212956_h = Screen.hasShiftDown();
                }
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.getVisible() && this.isFocused() && this.isEnabled();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean charTyped(char p_231042_1_, int p_231042_2_) {
        if (!this.canWrite()) {
            return false;
        }
        if (this.isNumeric(Character.toString(p_231042_1_))) {
            if (this.isEnabled) {
                this.writeText(Character.toString(p_231042_1_));
            }
            return true;
        }
        if (p_231042_1_ == '-') {
            if (!this.getText().contains("-") && this.cursorPosition == 0 && this.isEnabled) {
                this.writeText(Character.toString(p_231042_1_));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.getVisible()) {
            return false;
        }
        boolean flag = p_231044_1_ >= (double)this.x && p_231044_1_ < (double)(this.x + this.width) && p_231044_3_ >= (double)this.y && p_231044_3_ < (double)(this.y + this.height);
        boolean canLoseFocus = true;
        if (canLoseFocus) {
            this.setFocused2(flag);
        }
        if (this.isFocused() && flag && p_231044_5_ == 0) {
            int i = MathHelper.func_76128_c((double)p_231044_1_) - this.x;
            ((Object)((Object)this)).getClass();
            String s = this.fontRenderer.func_78269_a(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.func_78269_a(s, i -= 4).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.field_212956_h = false;
            this.setCursorPosition(0);
            if (!this.isNumeric(this.text) || this.text == "") {
                this.setText(this.defValue + "");
            }
        }
    }

    @Override
    public void render(int p_230431_2_, int p_230431_3_, float p_230431_4_) {
        super.render(p_230431_2_, p_230431_3_, p_230431_4_);
        if (this.getVisible()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(this.BG);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            if (this.isFocused()) {
                this.renderBtnBg(0, 16);
            } else if (this.hovered) {
                this.renderBtnBg(16, 0);
            } else {
                this.renderBtnBg(0, 0);
            }
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            int enabledColor = 0xE0E0E0;
            int disabledColor = 0x707070;
            int i2 = this.isEnabled ? enabledColor : disabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.func_78269_a(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && flag;
            ((Object)((Object)this)).getClass();
            int l = this.x + 4;
            ((Object)((Object)this)).getClass();
            int i1 = this.y + (this.height - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.fontRenderer.func_175063_a(this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, i2);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.fontRenderer.func_175063_a(this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, i2);
            }
            if (flag1) {
                if (flag2) {
                    AbstractGui.fill((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.fontRenderer.func_175063_a("_", (float)k1, (float)i1, i2);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.disableTexture();
        GlStateManager.enableColorLogicOp();
        GlStateManager.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableColorLogicOp();
        GlStateManager.enableTexture();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    @Override
    public boolean changeFocus(boolean p_231049_1_) {
        return this.isEnabled ? super.changeFocus(p_231049_1_) : false;
    }

    @Override
    public boolean isMouseOver(double p_231047_1_, double p_231047_3_) {
        return p_231047_1_ >= (double)this.x && p_231047_1_ < (double)(this.x + this.width) && p_231047_3_ >= (double)this.y && p_231047_3_ < (double)(this.y + this.height);
    }

    private boolean isEnabled() {
        return this.isEnabled;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.func_78269_a(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_78262_a(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public boolean getVisible() {
        return true;
    }

    private void renderBtnBg(int offsetX, int offsetY) {
        NumericTextField.blit((int)this.x, (int)this.y, (int)2, (int)2, (float)(0 + offsetX), (float)(0 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + this.width - 2), (int)this.y, (int)2, (int)2, (float)(14 + offsetX), (float)(0 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)this.x, (int)(this.y + this.height - 2), (int)2, (int)2, (float)(0 + offsetX), (float)(14 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + this.width - 2), (int)(this.y + this.height - 2), (int)2, (int)2, (float)(14 + offsetX), (float)(14 + offsetY), (int)2, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + 2), (int)this.y, (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)(0 + offsetY), (int)12, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + this.width - 2), (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)(14 + offsetX), (float)(2 + offsetY), (int)2, (int)12, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + 2), (int)(this.y + this.height - 2), (int)(this.width - 4), (int)2, (float)(2 + offsetX), (float)(14 + offsetY), (int)12, (int)2, (int)32, (int)32);
        NumericTextField.blit((int)this.x, (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)(0 + offsetX), (float)(2 + offsetY), (int)2, (int)12, (int)32, (int)32);
        NumericTextField.blit((int)(this.x + 2), (int)(this.y + 2), (int)(this.width - 4), (int)(this.height - 4), (float)(2 + offsetX), (float)(2 + offsetY), (int)12, (int)12, (int)32, (int)32);
    }

    private boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onChanged(NumericTextField var1);
    }
}

