/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.CheckBox;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ArmorConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton ViewBtn;
    private CustomButton BarsBtn;
    private CustomButton MoveAllBtn;
    private CustomButton ShowEmpty;
    private CustomButton ShowCount;
    private CustomButton ArmScale;
    private NumericTextField AboveField;

    public ArmorConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    protected void init() {
        super.init();
        String toggle = (Boolean)InventoryHUD.getConfig().getClient().ArmorDamage.get() != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, toggle, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.ToggleBtn.addListener(this::ToggleSwitch);
        this.AboveField = new NumericTextField(this.font, this.width / 2 + 20, 0, 40, 20, 0, 100, (Integer)InventoryHUD.getConfig().getClient().armAbove.get(), tf -> this.AboveChanged());
        this.OptionList.addWidget(this.AboveField, 1);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 20, 0, 20, 20, this::TypeArmorChanged, (Boolean)InventoryHUD.getConfig().getClient().showArmor.get(), new ResourceLocation("inventoryhud", "textures/gui/cb_arm.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 42, 0, 20, 20, this::TypeMainHandChanged, (Boolean)InventoryHUD.getConfig().getClient().showMain.get(), new ResourceLocation("inventoryhud", "textures/gui/cb_mh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 64, 0, 20, 20, this::TypeOffHandChanged, (Boolean)InventoryHUD.getConfig().getClient().showOff.get(), new ResourceLocation("inventoryhud", "textures/gui/cb_oh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 86, 0, 20, 20, this::TypeArrowChanged, (Boolean)InventoryHUD.getConfig().getClient().showArrows.get(), new ResourceLocation("inventoryhud", "textures/gui/cb_ar.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.width / 2 + 108, 0, 20, 20, this::TypeInvChanged, (Boolean)InventoryHUD.getConfig().getClient().showInv.get(), new ResourceLocation("inventoryhud", "textures/gui/cb_inv.png")), 2);
        this.ViewBtn = new CustomButton(this.width / 2 + 20, 0, 75, 20, ((InvConfig.ArmorView)((Object)InventoryHUD.getConfig().getClient().armView.get())).name(), null, false);
        this.OptionList.addWidget(this.ViewBtn, 3);
        this.ViewBtn.addListener(this::ViewSwitch);
        this.BarsBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getClient().armBars.get() + "", null, false);
        this.OptionList.addWidget(this.BarsBtn, 4);
        this.BarsBtn.addListener(this::BarsSwitch);
        this.MoveAllBtn = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getClient().moveAll.get() + "", null, false);
        this.OptionList.addWidget(this.MoveAllBtn, 5);
        this.MoveAllBtn.addListener(this::MoveSwitch);
        this.ShowEmpty = new CustomButton(this.width / 2 + 20, 0, 40, 20, InventoryHUD.getConfig().getClient().showEmpty.get() + "", null, false);
        this.OptionList.addWidget(this.ShowEmpty, 6);
        this.ShowEmpty.addListener(this::EmptySwitch);
        this.ShowCount = new CustomButton(this.width / 2 + 20, 0, 40, 20, ((Boolean)InventoryHUD.getClient().showCount.get()).toString(), null, false);
        this.OptionList.addWidget(this.ShowCount, 7);
        this.ShowCount.addListener(this::CountSwitch);
        float sc = (float)((Integer)InventoryHUD.getClient().armScale.get()).intValue() / 100.0f;
        String t = sc + "x";
        this.ArmScale = new CustomButton(this.width / 2 + 20, 0, 40, 20, t, null, false);
        this.OptionList.addWidget(this.ArmScale, 8);
        this.ArmScale.addListener(this::ScaleSwitch);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_SCALE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_SCALE_TT.getString(), x, y)), 8);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_COUNT.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_COUNT_TT.getString(), x, y)), 7);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_EMPTY.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_EMPTY_TT.getString(), x, y)), 6);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_MOVE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_MOVE_TT.stream().map(ITextComponent::getString).collect(Collectors.toList()), x, y)), 5);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_BARS.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_BARS_TT.getString(), x, y)), 4);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_VIEW.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_VIEW_TT.stream().map(ITextComponent::getString).collect(Collectors.toList()), x, y)), 3);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TYPE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_TYPE_TT.getString(), x, y)), 2);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_HIDE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_HIDE_TT.getString(), x, y)), 1);
        this.OptionList.addWidget(new TextWidget(this.width / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TOGGLE.getString(), this.font, (w, x, y) -> this.renderTooltip(Translation.ARM_TOGGLE_TT.getString(), x, y)), 0);
        this.AboveField.setMaxStringLength(5);
    }

    private void ScaleSwitch() {
        int scale = (InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale + 25) % 175;
        if (scale == 0) {
            scale = 50;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armScale = scale;
        InventoryHUD.getInstance().getInventoryGui().changeArmorOffset();
        InventoryHUD.getClient().armScale.set((Object)scale);
        float sc = (float)((Integer)InventoryHUD.getClient().armScale.get()).intValue() / 100.0f;
        String t = sc + "x";
        this.ArmScale.setMessage(t);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void CountSwitch() {
        Boolean bd = (Boolean)InventoryHUD.getConfig().getClient().showCount.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showCount = bd;
        InventoryHUD.getConfig().getClient().showCount.set((Object)bd);
        this.ShowCount.setMessage(bd.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArmor = cb.checked;
        InventoryHUD.getConfig().getClient().showArmor.set((Object)cb.checked);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showMain = cb.checked;
        InventoryHUD.getConfig().getClient().showMain.set((Object)cb.checked);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void TypeOffHandChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showOff = cb.checked;
        InventoryHUD.getConfig().getClient().showOff.set((Object)cb.checked);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showArrows = cb.checked;
        InventoryHUD.getConfig().getClient().showArrows.set((Object)cb.checked);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showInv = cb.checked;
        InventoryHUD.getConfig().getClient().showInv.set((Object)cb.checked);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void AboveChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AboveField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armAbove = a;
        InventoryHUD.getConfig().getClient().armAbove.set((Object)a);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void MoveSwitch() {
        Boolean bd = (Boolean)InventoryHUD.getConfig().getClient().moveAll.get() == false;
        InventoryHUD.getInstance().getInventoryGui().changeMoveAll(bd);
        InventoryHUD.getConfig().getClient().moveAll.set((Object)bd);
        this.MoveAllBtn.setMessage(bd.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void EmptySwitch() {
        Boolean bd = (Boolean)InventoryHUD.getClient().showEmpty.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.showEmpty = bd;
        InventoryHUD.getClient().showEmpty.set((Object)bd);
        this.ShowEmpty.setMessage(bd.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ViewSwitch() {
        InvConfig.ArmorView at = (InvConfig.ArmorView)((Object)InventoryHUD.getConfig().getClient().armView.get());
        switch (at) {
            case PERCENTAGE: {
                at = InvConfig.ArmorView.DAMAGE;
                break;
            }
            case DAMAGE: {
                at = InvConfig.ArmorView.DAMAGE_LEFT;
                break;
            }
            case DAMAGE_LEFT: {
                at = InvConfig.ArmorView.OFF;
                break;
            }
            case OFF: {
                at = InvConfig.ArmorView.PERCENTAGE;
            }
        }
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armView = at;
        InventoryHUD.getConfig().getClient().armView.set((Object)at);
        this.ViewBtn.setMessage(at.name());
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void ToggleSwitch() {
        Boolean armor = (Boolean)InventoryHUD.getConfig().getClient().ArmorDamage.get() == false;
        InventoryHUD.armorHUD = armor;
        InventoryHUD.getConfig().getClient().ArmorDamage.set((Object)armor);
        String armString = armor != false ? TextFormatting.DARK_GREEN + "ON" : TextFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(armString);
        InventoryHUD.getConfig().clientSpec.save();
    }

    private void BarsSwitch() {
        Boolean bars = (Boolean)InventoryHUD.getConfig().getClient().armBars.get() == false;
        InventoryHUD.getInstance().getInventoryGui().armorRenderer.armBars = bars;
        InventoryHUD.getConfig().getClient().armBars.set((Object)bars);
        this.BarsBtn.setMessage(bars.toString());
        InventoryHUD.getConfig().clientSpec.save();
    }
}

