/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EachArmorRenderer
extends ArmorRenderer {
    public EachArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(int width, int height) {
        boolean right;
        int i = 5;
        float scale = (float)this.armScale / 100.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-320.0);
        for (ItemStack item : this.mc.field_71439_g.func_184209_aF()) {
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            int x = this.getX(width, (int)(16.0f * scale), this.items[i].x, this.items[i].aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * scale), this.items[i].y, this.items[i].aligns.VertAlign);
            right = this.getRight(this.items[i].x, this.items[i].aligns.HorAlign);
            int Damage = ArmorStatus.GetDamage(item);
            String text = null;
            if (Damage >= 0 && Damage <= this.armAbove) {
                if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (this.armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(item.func_77952_i()), Damage);
                            break;
                        }
                        case DAMAGE_LEFT: {
                            text = this.getDamageText(String.valueOf(item.func_77958_k() - item.func_77952_i()), Damage);
                        }
                    }
                }
                this.pushAndRender(x, y, !right, null, item, text, this.armBars, scale);
            } else if (Damage == -2) {
                String t = null;
                boolean over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    t = "" + this.getItemCount(item);
                    over = false;
                }
                this.pushAndRender(x, y, !right, null, item, t, over, scale);
            } else if (this.showEmpty) {
                this.pushAndRender(x, y, !right, this.armorRL[i], null, null, false, scale);
            }
            --i;
        }
        if (this.showArrows || this.showInv) {
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.mc.field_71439_g.field_71071_by.field_70462_a) {
                if (slot.func_190926_b()) {
                    ++count;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.func_190916_E();
            }
            if (this.showInv) {
                int x = this.getX(width, (int)(16.0f * scale), this.items[6].x, this.items[6].aligns.HorAlign);
                int y = this.getY(height, (int)(16.0f * scale), this.items[6].y, this.items[6].aligns.VertAlign);
                right = this.getRight(this.items[6].x, this.items[6].aligns.HorAlign);
                this.pushAndRender(x, y, !right, this.armorRL[6], null, "" + count, false, scale);
            }
            if (this.showArrows) {
                int x = this.getX(width, (int)(16.0f * scale), this.items[7].x, this.items[7].aligns.HorAlign);
                int y = this.getY(height, (int)(16.0f * scale), this.items[7].y, this.items[7].aligns.VertAlign);
                right = this.getRight(this.items[7].x, this.items[7].aligns.HorAlign);
                this.pushAndRender(x, y, !right, this.armorRL[7], null, "" + arrows, false, scale);
            }
        }
        RenderSystem.popMatrix();
    }

    private void pushAndRender(int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        this.renderElement(0, 0, right, resourceLocation, itemStack, text, over);
        RenderSystem.popMatrix();
    }
}

