/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.utils.Color4F;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class ConfigWidget
extends Widget {
    protected ResourceLocation resourceLocation;
    protected ResourceLocation icon;
    protected float texOffX;
    protected float texOffY;
    protected float scale;
    protected Color4F color;
    protected boolean isShow;
    protected boolean isDisableable;
    protected boolean snapable;
    private final List<ConfigWidgetListener> listeners = new ArrayList<ConfigWidgetListener>();
    private final List<ConfigWidgetPosListener> posListeners = new ArrayList<ConfigWidgetPosListener>();
    private double d_x;
    private double d_y;

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, boolean snapable, String msg, boolean isShow, boolean isDisableable) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, isDisableable);
        this.snapable = snapable;
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, true);
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow, boolean isDisableable) {
        super(xIn, yIn, (int)((float)widthIn * scaleIn), (int)((float)heightIn * scaleIn), msg);
        this.d_x = xIn;
        this.d_y = yIn;
        this.isShow = isShow;
        this.scale = scaleIn;
        this.isDisableable = isDisableable;
        this.snapable = true;
    }

    public void addListener(ConfigWidgetListener act) {
        this.listeners.add(act);
    }

    public void addPosListener(ConfigWidgetPosListener act) {
        this.posListeners.add(act);
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn) {
        this.initTextureValues(xTexStartIn, yTexStartIn, color, resourceLocationIn, null);
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn, ResourceLocation icon) {
        this.resourceLocation = resourceLocationIn;
        this.texOffX = (float)xTexStartIn * this.scale;
        this.texOffY = (float)yTexStartIn * this.scale;
        this.color = color;
        this.icon = icon;
    }

    private void renderBg() {
        ConfigWidget.blit((int)this.x, (int)this.y, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + this.width - 3), (int)this.y, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)this.x, (int)(this.y + this.height - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + this.width - 3), (int)(this.y + this.height - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + 3), (int)this.y, (int)(this.width - 6), (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + this.width - 3), (int)(this.y + 3), (int)3, (int)(this.height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + 3), (int)(this.y + this.height - 3), (int)(this.width - 6), (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.blit((int)this.x, (int)(this.y + 3), (int)3, (int)(this.height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.blit((int)(this.x + 3), (int)(this.y + 3), (int)(this.width - 6), (int)(this.height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)256, (int)256);
    }

    public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.resourceLocation);
        RenderSystem.disableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)this.color.a);
        this.renderBg();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.icon != null) {
            minecraft.func_110434_K().func_110577_a(this.icon);
            int size = 16;
            if (this.width < 16) {
                size = this.width - 2;
            }
            ConfigWidget.blit((int)(this.x + this.width / 2 - size / 2), (int)(this.y + this.height / 2 - size / 2), (float)size, (float)size, (int)size, (int)size, (int)size, (int)size);
        }
        if (this.isDisableable) {
            if (this.isShow) {
                this.blit(this.x + this.width - 12, this.y + 2, 162, 0, 10, 10);
            } else {
                this.blit(this.x + this.width - 12, this.y + 2, 172, 0, 10, 10);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableDepthTest();
        this.drawCenteredString(minecraft.field_71466_p, this.getMessage(), this.x + this.getWidth() / 2, this.y + this.getHeight() / 2 - 3, 0xFFFFFF);
    }

    public void onRelease(double p_onRelease_1_, double p_onRelease_3_) {
        this.d_x = this.x;
        this.d_y = this.y;
    }

    public boolean mouseClicked(double x, double y, int p_mouseClicked_5_) {
        boolean flag;
        if (this.active && this.visible && this.isValidClickButton(p_mouseClicked_5_) && (flag = this.clicked(x, y))) {
            if (this.isDisableable && x >= (double)(this.x + this.width - 12) && x < (double)(this.width + this.x - 2) && y >= (double)(this.y + 2) && y < (double)(this.y + 12)) {
                this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                this.isShow = !this.isShow;
                for (ConfigWidgetListener hl : this.listeners) {
                    hl.onShowChanged();
                }
            }
            this.onClick(x, y);
            return true;
        }
        return false;
    }

    protected void onDrag(double p_onDrag_1_, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.d_x += p_onDrag_5_;
        this.d_y += p_onDrag_7_;
        Minecraft mc = Minecraft.func_71410_x();
        if (!this.snapable) {
            this.x = this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.field_71462_r.width - this.getWidth()) ? mc.field_71462_r.width - this.getWidth() : (int)this.d_x);
            this.y = this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.field_71462_r.height - this.getHeight()) ? mc.field_71462_r.height - this.getHeight() : (int)this.d_y);
        } else {
            this.x = this.d_x + (double)(this.width / 2) <= (double)(mc.field_71462_r.width / 2 - 10) || this.d_x + (double)(this.width / 2) >= (double)(mc.field_71462_r.width / 2 + 10) ? (this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.field_71462_r.width - this.width) ? mc.field_71462_r.width - this.width : (int)this.d_x)) : mc.field_71462_r.width / 2 - this.width / 2;
            this.y = this.d_y + (double)(this.height / 2) <= (double)(mc.field_71462_r.height / 2 - 10) || this.d_y + (double)(this.height / 2) >= (double)(mc.field_71462_r.height / 2 + 10) ? (this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.field_71462_r.height - this.height) ? mc.field_71462_r.height - this.height : (int)this.d_y)) : mc.field_71462_r.height / 2 - this.height / 2;
        }
        for (ConfigWidgetPosListener hl : this.posListeners) {
            hl.onPosChanged(this);
        }
    }

    public static interface ConfigWidgetPosListener {
        public void onPosChanged(ConfigWidget var1);
    }

    public static interface ConfigWidgetListener {
        public void onShowChanged();
    }
}

