/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.renderers.BlockArmorRenderer;
import dlovin.inventoryhud.gui.renderers.EachArmorRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryGui
extends IngameGui {
    private final ItemRenderer itemRenderer;
    private final FontRenderer fontRenderer;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    public static int invX;
    public static int invY;
    public static WidgetAligns InvAligns;
    public static float invAlpha;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean animated;
    public static boolean hideBackground;
    private static final ResourceLocation INVBG;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;

    public InventoryGui() {
        super(Minecraft.func_71410_x());
        this.itemRenderer = this.minecraft.func_175599_af();
        this.fontRenderer = this.minecraft.field_71466_p;
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        int armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer = (Boolean)InventoryHUD.getClient().moveAll.get() == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
        this.potionRenderer = (Boolean)InventoryHUD.getClient().potHor.get() != false ? ((Boolean)InventoryHUD.getClient().potMini.get() != false ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : ((Boolean)InventoryHUD.getClient().potMini.get() != false ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
        InventoryHUD.isActive = (Boolean)InventoryHUD.getClient().byDefault.get();
        InventoryHUD.armorHUD = (Boolean)InventoryHUD.getClient().ArmorDamage.get();
        InventoryHUD.potionHUD = (Boolean)InventoryHUD.getClient().Potions.get();
        invX = (Integer)InventoryHUD.getClient().xPos.get();
        invY = (Integer)InventoryHUD.getClient().yPos.get();
        InvAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invValign.get()));
        invMini = (Boolean)InventoryHUD.getClient().invMini.get();
        invVert = (Boolean)InventoryHUD.getClient().invVert.get();
        animated = (Boolean)InventoryHUD.getClient().animatedInv.get();
        hideBackground = (Boolean)InventoryHUD.getClient().hideBackground.get();
        invAlpha = (float)((Integer)InventoryHUD.getClient().invAlpha.get()).intValue() / 100.0f;
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = (Integer)InventoryHUD.getClient().xPotionPos.get();
        this.potionRenderer.potY = (Integer)InventoryHUD.getClient().yPotionPos.get();
        this.potionRenderer.PotAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().potHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().potValign.get()));
        this.potionRenderer.potMini = (Boolean)InventoryHUD.getClient().potMini.get();
        this.potionRenderer.potGap = (Integer)InventoryHUD.getClient().potGap.get();
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < this.field_73839_d.func_228018_at_().func_198087_p() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)((Integer)InventoryHUD.getClient().potAlpha.get()).intValue() / 100.0f;
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        this.armorRenderer.armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer.ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        this.armorRenderer.armAbove = (Integer)InventoryHUD.getClient().armAbove.get();
        this.armorRenderer.armScale = (Integer)InventoryHUD.getClient().armScale.get();
        this.armorRenderer.showArmor = (Boolean)InventoryHUD.getClient().showArmor.get();
        this.armorRenderer.showMain = (Boolean)InventoryHUD.getClient().showMain.get();
        this.armorRenderer.showOff = (Boolean)InventoryHUD.getClient().showOff.get();
        this.armorRenderer.showArrows = (Boolean)InventoryHUD.getClient().showArrows.get();
        this.armorRenderer.showInv = (Boolean)InventoryHUD.getClient().showInv.get();
        this.armorRenderer.showEmpty = (Boolean)InventoryHUD.getClient().showEmpty.get();
        this.armorRenderer.showCount = (Boolean)InventoryHUD.getClient().showCount.get();
        this.armorRenderer.armView = (InvConfig.ArmorView)((Object)InventoryHUD.getClient().armView.get());
        this.armorRenderer.armBars = (Boolean)InventoryHUD.getClient().armBars.get();
        this.armorRenderer.items[0] = new EachItem((Integer)InventoryHUD.getClient().helmPosX.get(), (Integer)InventoryHUD.getClient().helmPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().helmHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().helmVal.get())));
        this.armorRenderer.items[1] = new EachItem((Integer)InventoryHUD.getClient().chestPosX.get(), (Integer)InventoryHUD.getClient().chestPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().chestHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().chestVal.get())));
        this.armorRenderer.items[2] = new EachItem((Integer)InventoryHUD.getClient().legPosX.get(), (Integer)InventoryHUD.getClient().legPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().legHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().legVal.get())));
        this.armorRenderer.items[3] = new EachItem((Integer)InventoryHUD.getClient().bootPosX.get(), (Integer)InventoryHUD.getClient().bootPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().bootHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().bootVal.get())));
        this.armorRenderer.items[4] = new EachItem((Integer)InventoryHUD.getClient().offPosX.get(), (Integer)InventoryHUD.getClient().offPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().offHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().offVal.get())));
        this.armorRenderer.items[5] = new EachItem((Integer)InventoryHUD.getClient().mainPosX.get(), (Integer)InventoryHUD.getClient().mainPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().mainHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().mainVal.get())));
        this.armorRenderer.items[6] = new EachItem((Integer)InventoryHUD.getClient().invPosX.get(), (Integer)InventoryHUD.getClient().invPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invVal.get())));
        this.armorRenderer.items[7] = new EachItem((Integer)InventoryHUD.getClient().arrPosX.get(), (Integer)InventoryHUD.getClient().arrPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().arrHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().arrVal.get())));
        this.changeArmorOffset();
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && InventoryHUD.potionHUD) {
            event.setCanceled(true);
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        MatrixStack mat = new MatrixStack();
        int width = this.field_73839_d.func_228018_at_().func_198107_o();
        int height = this.field_73839_d.func_228018_at_().func_198087_p();
        RenderSystem.pushMatrix();
        if (InventoryHUD.armorHUD) {
            this.armorRenderer.render(mat, width, height);
        }
        if (InventoryHUD.potionHUD) {
            this.potionRenderer.render(mat, width, height);
        }
        if (InventoryHUD.isActive && !(this.field_73839_d.field_71462_r instanceof ContainerScreen)) {
            this.RenderInventory(mat, width, height, event.getPartialTicks());
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
    }

    private void RenderInventory(MatrixStack mat, int width, int height, float partialTicks) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        double scale = invMini ? 0.75 : 1.0;
        int px = this.getX(width, (int)((double)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((double)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.field_73839_d.field_71439_g.field_71071_by.field_70462_a.get(index);
                if (item == null || item.func_77973_b().equals(Items.field_190931_a)) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.func_190921_D() - partialTicks;
                    if (animated && f > 0.0f) {
                        RenderSystem.pushMatrix();
                        float f1 = 1.0f + f / 5.0f;
                        RenderSystem.translatef((float)(finalI * 18 + 12), (float)(finalJ * 18 + 12), (float)0.0f);
                        RenderSystem.scalef((float)((f1 + 1.0f) / 2.0f), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                        RenderSystem.translatef((float)(-(finalI * 18 + 12)), (float)(-(finalJ * 18 + 12)), (float)0.0f);
                    }
                    this.itemRenderer.func_180450_b(item, finalI * 18, finalJ * 18);
                    if (animated && f > 0.0f) {
                        RenderSystem.popMatrix();
                    }
                    this.itemRenderer.func_180453_a(this.fontRenderer, item, finalI * 18, finalJ * 18, null);
                });
            }
        }
        if (hideBackground && items.size() == 0) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)px, (double)py, (double)-255.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
        this.field_73839_d.func_110434_K().func_110577_a(INVBG);
        InventoryGui.func_238466_a_((MatrixStack)mat, (int)-8, (int)-8, (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (int)256, (int)256);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        items.forEach(r -> r.run());
        RenderSystem.popMatrix();
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = x;
                break;
            }
            case MIDDLE: {
                result = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = 0;
        switch (val) {
            case TOP: {
                result = y;
                break;
            }
            case CENTER: {
                result = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        float scale = (float)this.armorRenderer.armScale / 100.0f;
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * scale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.minecraft);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.minecraft);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        int armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, (Boolean)InventoryHUD.getClient().potHor.get());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion((Boolean)InventoryHUD.getClient().potMini.get(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : (mini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
    }

    static {
        INVBG = new ResourceLocation("inventoryhud", "textures/gui/inv_bg.png");
    }
}

