/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class HorizontalPotionRenderer
extends PotionRenderer {
    private final ResourceLocation PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_hor.png");

    public HorizontalPotionRenderer(Minecraft mc) {
        super(mc);
    }

    private int getX(int width, int effCount) {
        int result = 0;
        switch (this.PotAligns.HorAlign) {
            case LEFT: {
                result = this.potX;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    result = width / 2 - 18 - this.potX;
                    break;
                }
                if (this.potX < 0) {
                    result = width / 2 - 18 - (effCount - 1) * (36 + this.potGap) - this.potX;
                    break;
                }
                result = (int)((float)(width / 2 - 18) - (float)(effCount - 1) * ((float)this.potGap / 2.0f + 18.0f) - (float)this.potX);
                break;
            }
            case RIGHT: {
                result = width - this.potX - (effCount - 1) * (this.potGap + 36);
            }
        }
        return result;
    }

    private int getY(int height) {
        int result = 0;
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                result = this.potY;
                break;
            }
            case CENTER: {
                result = height / 2 - 18 - this.potY;
                break;
            }
            case BOTTOM: {
                result = height - this.potY;
            }
        }
        return result;
    }

    @Override
    public void render(MatrixStack mat, int width, int height) {
        int x = 0;
        int effCount = this.mc.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        PotionSpriteUploader potionspriteuploader = this.mc.func_213248_ap();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        int xPos = this.getX(width, effCount);
        int yPos = this.getY(height);
        for (EffectInstance effect : this.mc.field_71439_g.func_70651_bq()) {
            Effect pot = effect.func_188419_a();
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            this.mc.func_110434_K().func_110577_a(this.PBG);
            this.blit(mat, xPos + x, yPos, 36.0f, 38.0f, 36, 38, 36, 38);
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(pot);
            this.mc.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            HorizontalPotionRenderer.func_238470_a_((MatrixStack)mat, (int)(xPos + x + 9), (int)(yPos + 3), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            ResourceLocation lev = effect.func_76458_c() < 9 && effect.func_76458_c() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.mc.func_110434_K().func_110577_a(lev);
            this.blit(mat, xPos + x + 21, yPos, 9.0f, 9.0f, 9, 9, 9, 9);
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (dur > 1600) {
                time = " **:**";
            } else {
                String mins = dur / 60 + "";
                String secs = dur % 60 + "";
                if (dur / 60 < 10) {
                    mins = "0" + mins;
                }
                if (dur % 60 < 10) {
                    secs = "0" + secs;
                }
                time = dur > 10 ? mins + ":" + secs : TextFormatting.RED + mins + TextFormatting.WHITE + ":" + TextFormatting.RED + secs;
            }
            this.fontRenderer.func_238405_a_(mat, time, (float)(xPos + x + 5), (float)(yPos + 25), 0xFFFFFF);
            x += 36 + this.potGap;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

