/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.utils.Color4F;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ConfigWidget
extends Widget {
    protected ResourceLocation resourceLocation;
    protected float texOffX;
    protected float texOffY;
    protected float scale;
    protected Color4F color;
    protected boolean isShow;
    protected boolean isDisableable;
    protected boolean snapable;
    protected ResourceLocation icon;
    private final List<ConfigWidgetListener> listeners = new ArrayList<ConfigWidgetListener>();
    private final List<ConfigWidgetPosListener> posListeners = new ArrayList<ConfigWidgetPosListener>();
    private double d_x;
    private double d_y;

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, boolean snapable, ITextComponent msg, boolean isShow, boolean isDisableable) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, isDisableable);
        this.snapable = snapable;
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, ITextComponent msg, boolean isShow) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, true);
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, ITextComponent msg, boolean isShow, boolean isDisableable) {
        super(xIn, yIn, (int)((float)widthIn * scaleIn), (int)((float)heightIn * scaleIn), msg);
        this.d_x = xIn;
        this.d_y = yIn;
        this.isShow = isShow;
        this.scale = scaleIn;
        this.isDisableable = isDisableable;
        this.snapable = true;
    }

    public void addListener(ConfigWidgetListener act) {
        this.listeners.add(act);
    }

    public void addPosListener(ConfigWidgetPosListener act) {
        this.posListeners.add(act);
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn) {
        this.initTextureValues(xTexStartIn, yTexStartIn, color, resourceLocationIn, null);
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn, ResourceLocation icon) {
        this.resourceLocation = resourceLocationIn;
        this.texOffX = (float)xTexStartIn * this.scale;
        this.texOffY = (float)yTexStartIn * this.scale;
        this.color = color;
        this.icon = icon;
    }

    private void renderBg(MatrixStack mat) {
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + this.field_230688_j_ - 3), (int)this.field_230691_m_, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)this.field_230690_l_, (int)(this.field_230691_m_ + this.field_230689_k_ - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + this.field_230688_j_ - 3), (int)(this.field_230691_m_ + this.field_230689_k_ - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + 3), (int)this.field_230691_m_, (int)(this.field_230688_j_ - 6), (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + this.field_230688_j_ - 3), (int)(this.field_230691_m_ + 3), (int)3, (int)(this.field_230689_k_ - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + this.field_230689_k_ - 3), (int)(this.field_230688_j_ - 6), (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)this.field_230690_l_, (int)(this.field_230691_m_ + 3), (int)3, (int)(this.field_230689_k_ - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)256, (int)256);
        ConfigWidget.func_238466_a_((MatrixStack)mat, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + 3), (int)(this.field_230688_j_ - 6), (int)(this.field_230689_k_ - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)256, (int)256);
    }

    public void func_230431_b_(MatrixStack mat, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(this.resourceLocation);
        RenderSystem.disableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)this.color.a);
        this.renderBg(mat);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.icon != null) {
            minecraft.func_110434_K().func_110577_a(this.icon);
            int size = 16;
            if (this.field_230688_j_ < 16) {
                size = this.field_230688_j_ - 2;
            }
            ConfigWidget.func_238463_a_((MatrixStack)mat, (int)(this.field_230690_l_ + this.field_230688_j_ / 2 - size / 2), (int)(this.field_230691_m_ + this.field_230689_k_ / 2 - size / 2), (float)size, (float)size, (int)size, (int)size, (int)size, (int)size);
        }
        minecraft.func_110434_K().func_110577_a(this.resourceLocation);
        if (this.isDisableable) {
            if (this.isShow) {
                this.func_238474_b_(mat, this.field_230690_l_ + this.field_230688_j_ - 12, this.field_230691_m_ + 2, 162, 0, 10, 10);
            } else {
                this.func_238474_b_(mat, this.field_230690_l_ + this.field_230688_j_ - 12, this.field_230691_m_ + 2, 172, 0, 10, 10);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableDepthTest();
        this.drawCenterAlignedString(mat, minecraft.field_71466_p, this.func_230458_i_().getString(), this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_ + this.field_230689_k_ / 2 - 3, 0xFFFFFF);
    }

    public void func_231000_a__(double p_onRelease_1_, double p_onRelease_3_) {
        this.d_x = this.field_230690_l_;
        this.d_y = this.field_230691_m_;
    }

    public boolean func_231044_a_(double x, double y, int p_mouseClicked_5_) {
        boolean flag;
        if (this.field_230693_o_ && this.field_230694_p_ && this.func_230987_a_(p_mouseClicked_5_) && (flag = this.func_230992_c_(x, y))) {
            if (this.isDisableable && x >= (double)(this.field_230690_l_ + this.field_230688_j_ - 12) && x < (double)(this.field_230688_j_ + this.field_230690_l_ - 2) && y >= (double)(this.field_230691_m_ + 2) && y < (double)(this.field_230691_m_ + 12)) {
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                this.isShow = !this.isShow;
                for (ConfigWidgetListener hl : this.listeners) {
                    hl.onShowChanged(this);
                }
            }
            this.func_230982_a_(x, y);
            return true;
        }
        return false;
    }

    protected void func_230983_a_(double p_onDrag_1_, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        super.func_230983_a_(p_onDrag_1_, p_onDrag_3_, p_onDrag_5_, p_onDrag_7_);
        this.d_x += p_onDrag_5_;
        this.d_y += p_onDrag_7_;
        Minecraft mc = Minecraft.func_71410_x();
        if (!this.snapable) {
            this.field_230690_l_ = this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.field_71462_r.field_230708_k_ - this.getWidth()) ? mc.field_71462_r.field_230708_k_ - this.getWidth() : (int)this.d_x);
            this.field_230691_m_ = this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.field_71462_r.field_230709_l_ - this.getHeight()) ? mc.field_71462_r.field_230709_l_ - this.getHeight() : (int)this.d_y);
        } else {
            this.field_230690_l_ = this.d_x + (double)(this.getWidth() / 2) <= (double)(mc.field_71462_r.field_230708_k_ / 2 - 10) || this.d_x + (double)(this.getWidth() / 2) >= (double)(mc.field_71462_r.field_230708_k_ / 2 + 10) ? (this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.field_71462_r.field_230708_k_ - this.getWidth()) ? mc.field_71462_r.field_230708_k_ - this.getWidth() : (int)this.d_x)) : mc.field_71462_r.field_230708_k_ / 2 - this.getWidth() / 2;
            this.field_230691_m_ = this.d_y + (double)(this.getHeight() / 2) <= (double)(mc.field_71462_r.field_230709_l_ / 2 - 10) || this.d_y + (double)(this.getHeight() / 2) >= (double)(mc.field_71462_r.field_230709_l_ / 2 + 10) ? (this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.field_71462_r.field_230709_l_ - this.getHeight()) ? mc.field_71462_r.field_230709_l_ - this.getHeight() : (int)this.d_y)) : mc.field_71462_r.field_230709_l_ / 2 - this.getHeight() / 2;
        }
        for (ConfigWidgetPosListener hl : this.posListeners) {
            hl.onPosChanged(this);
        }
    }

    public int getWidth() {
        return this.field_230688_j_;
    }

    public int getHeight() {
        return this.field_230689_k_;
    }

    public void drawCenterAlignedString(MatrixStack mat, FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_238405_a_(mat, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    public static interface ConfigWidgetPosListener {
        public void onPosChanged(ConfigWidget var1);
    }

    public static interface ConfigWidgetListener {
        public void onShowChanged(ConfigWidget var1);
    }
}

