/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities;

import com.google.common.collect.Lists;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntities;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.ReflectionClient;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.DistExecutor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicMirrorCoreTileEntity
extends MagicMirrorBaseTileEntity
implements ITickableTileEntity {
    private static final int REFLECTION_UPDATE_INTERVAL = 10;
    private final List<MagicMirrorTileEntityModifier> modifiers = Lists.newArrayList();
    private final Reflection reflection = (Reflection)DistExecutor.unsafeRunForDist(() -> ReflectionClient::new, () -> Reflection::new);
    private int reflectionUpdateCounter = 10;

    public MagicMirrorCoreTileEntity() {
        super((TileEntityType<? extends MagicMirrorBaseTileEntity>)((TileEntityType)TileEntities.MAGIC_MIRROR_CORE.get()));
    }

    private static List<PlayerEntity> findReflectablePlayers(IEntityReader world, BlockPos ownPosition) {
        AxisAlignedBB scanBB = new AxisAlignedBB(ownPosition.func_177982_a(-10, -4, -10), ownPosition.func_177982_a(10, 4, 10));
        List playerEntities = world.func_217357_a(PlayerEntity.class, scanBB);
        return playerEntities.stream().filter(player -> !(player instanceof FakePlayer)).collect(Collectors.toList());
    }

    @Nullable
    private static PlayerEntity findPlayerToReflect(IEntityReader world, BlockPos ownPosition) {
        List<PlayerEntity> players = MagicMirrorCoreTileEntity.findReflectablePlayers(world, ownPosition);
        if (players.isEmpty()) {
            return null;
        }
        return Collections.min(players, Comparator.comparingDouble(player -> ownPosition.func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true)));
    }

    @Override
    @Nullable
    protected MagicMirrorCoreTileEntity getCore() {
        return this;
    }

    private void updateReflection() {
        World world = this.func_145831_w();
        if (world != null) {
            BlockState blockState = this.func_195044_w();
            this.reflection.setAngle(((Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l());
            PlayerEntity playerToReflect = MagicMirrorCoreTileEntity.findPlayerToReflect((IEntityReader)world, this.func_174877_v());
            if (playerToReflect == null) {
                this.reflection.stopReflecting();
            } else {
                this.reflection.setReflectedEntity((Entity)playerToReflect);
            }
        }
    }

    public void func_73660_a() {
        if (this.reflectionUpdateCounter++ == 10) {
            this.reflectionUpdateCounter = 0;
            this.updateReflection();
        }
        this.modifiers.forEach(MagicMirrorTileEntityModifier::coolDown);
    }

    public void onChunkUnloaded() {
        this.reflection.stopReflecting();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.reflection.stopReflecting();
        this.reflectionUpdateCounter = 10;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return this.writeInternal(super.func_189515_b(compound));
    }

    private CompoundNBT writeInternal(CompoundNBT compound) {
        ListNBT modifierList = new ListNBT();
        for (MagicMirrorTileEntityModifier modifier : this.modifiers) {
            CompoundNBT modifierCompound = new CompoundNBT();
            modifierCompound.func_74778_a("name", modifier.getName());
            modifierList.add((Object)modifier.write(modifierCompound));
        }
        compound.func_218657_a("modifiers", (INBT)modifierList);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readInternal(compound);
    }

    private void readInternal(CompoundNBT compound) {
        ListNBT modifiers = compound.func_150295_c("modifiers", 10);
        for (INBT modifierCompound : modifiers) {
            String name;
            MagicMirrorModifier modifier;
            if (!(modifierCompound instanceof CompoundNBT) || (modifier = MagicMirrorModifier.getModifier(name = ((CompoundNBT)modifierCompound).func_74779_i("name"))) == null) continue;
            modifier.apply((MagicMirrorBaseTileEntity)this, (CompoundNBT)modifierCompound);
        }
    }

    @Override
    @Nullable
    public Reflection getReflection() {
        return this.reflection;
    }

    @Override
    public List<MagicMirrorTileEntityModifier> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    @Override
    public boolean tryActivate(PlayerEntity playerIn, Hand hand) {
        return this.modifiers.stream().anyMatch(modifier -> modifier.tryPlayerActivate(this, playerIn, hand));
    }

    @Override
    public void addModifier(MagicMirrorTileEntityModifier modifier) {
        this.modifiers.add(modifier);
        modifier.activate(this);
        this.func_70296_d();
    }

    @Override
    public void removeModifiers(World worldIn, BlockPos pos) {
        for (MagicMirrorTileEntityModifier modifier : this.modifiers) {
            modifier.deactivate(this);
            modifier.remove(worldIn, pos);
        }
        this.modifiers.clear();
    }

    public CompoundNBT func_189517_E_() {
        return this.writeInternal(super.func_189517_E_());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readInternal(pkt.func_148857_g());
    }
}

