/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers;

import com.tomboshoven.minecraft.magicmirror.MagicMirrorMod;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.packets.Network;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ArmorReflectionModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ArmorReflectionModifierClient;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ArmorMagicMirrorTileEntityModifier
extends MagicMirrorTileEntityModifier {
    private static final int COOLDOWN_TICKS = 20;
    private static final int SWAP_PARTICLE_COUNT = 64;
    private final ReplacementArmor replacementArmor = new ReplacementArmor();
    @Nullable
    private ArmorReflectionModifier reflectionModifier;

    public ArmorMagicMirrorTileEntityModifier(MagicMirrorModifier modifier) {
        super(modifier);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        return this.replacementArmor.write(super.write(nbt));
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.replacementArmor.read(nbt);
    }

    @Override
    public void remove(World world, BlockPos pos) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)Items.field_179565_cj));
        this.replacementArmor.spawn(world, pos);
    }

    @Override
    public void activate(MagicMirrorBaseTileEntity tileEntity) {
        Reflection reflection = tileEntity.getReflection();
        if (reflection != null) {
            this.reflectionModifier = this.createReflectionModifier();
            reflection.addModifier(this.reflectionModifier);
        }
    }

    private ArmorReflectionModifier createReflectionModifier() {
        return (ArmorReflectionModifier)DistExecutor.runForDist(() -> () -> new ArmorReflectionModifierClient(this.replacementArmor), () -> () -> new ArmorReflectionModifier(this.replacementArmor));
    }

    @Override
    public void deactivate(MagicMirrorBaseTileEntity tileEntity) {
        Reflection reflection;
        if (this.reflectionModifier != null && (reflection = tileEntity.getReflection()) != null) {
            reflection.removeModifier(this.reflectionModifier);
        }
    }

    @Override
    public boolean tryPlayerActivate(MagicMirrorBaseTileEntity tileEntity, PlayerEntity playerIn, Hand hand) {
        if (this.coolingDown()) {
            return false;
        }
        if (!(playerIn instanceof ServerPlayerEntity)) {
            return false;
        }
        if (!this.tryEquipArmor(tileEntity, playerIn, hand)) {
            this.swapArmor(tileEntity, playerIn);
        }
        return true;
    }

    private boolean tryEquipArmor(MagicMirrorBaseTileEntity tileEntity, PlayerEntity playerIn, Hand hand) {
        int slotIndex;
        EquipmentSlotType equipmentSlotType;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ArmorItem && (equipmentSlotType = MobEntity.func_184640_d((ItemStack)heldItem)).func_188453_a() == EquipmentSlotType.Group.ARMOR && this.replacementArmor.isEmpty(slotIndex = equipmentSlotType.func_188454_b())) {
            BlockPos pos = tileEntity.func_174877_v();
            World world = tileEntity.func_145831_w();
            if (world != null) {
                MessageEquip message = new MessageEquip(pos, slotIndex, heldItem);
                PacketDistributor.PacketTarget mirrorTarget = PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos));
                Network.CHANNEL.send(mirrorTarget, (Object)message);
            }
            this.replacementArmor.set(slotIndex, heldItem.func_77946_l());
            heldItem.func_190920_e(0);
            tileEntity.func_70296_d();
            return true;
        }
        return false;
    }

    private void swapArmor(MagicMirrorBaseTileEntity tileEntity, PlayerEntity playerIn) {
        BlockPos pos = tileEntity.func_174877_v();
        World world = tileEntity.func_145831_w();
        if (world != null) {
            MessageSwapMirror mirrorMessage = new MessageSwapMirror(tileEntity, playerIn);
            PacketDistributor.PacketTarget mirrorTarget = PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos));
            Network.CHANNEL.send(mirrorTarget, (Object)mirrorMessage);
        }
        MessageSwapPlayer playerMessage = new MessageSwapPlayer(this, playerIn);
        PacketDistributor.PacketTarget playerTarget = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerIn);
        Network.CHANNEL.send(playerTarget, (Object)playerMessage);
        this.replacementArmor.swap(playerIn);
        MagicMirrorMod.LOGGER.debug("Swapped inventory of mirror");
        this.setCooldown(20);
        tileEntity.func_70296_d();
    }

    private ReplacementArmor getReplacementArmor() {
        return this.replacementArmor;
    }

    public static void onMessageEquip(MessageEquip message, Supplier<? extends NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TileEntity te;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (te = world.func_175625_s(message.mirrorPos)) instanceof MagicMirrorBaseTileEntity) {
                ((MagicMirrorBaseTileEntity)te).getModifiers().stream().filter(modifier -> modifier instanceof ArmorMagicMirrorTileEntityModifier).findFirst().map(ArmorMagicMirrorTileEntityModifier.class::cast).ifPresent(modifier -> modifier.replacementArmor.set(message.slotIdx, message.armor));
                ArmorItem item = (ArmorItem)message.armor.func_77973_b();
                world.func_184156_a(message.mirrorPos, item.func_200880_d().func_200899_b(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }));
        ctx.setPacketHandled(true);
    }

    public static void onMessageSwapMirror(MessageSwapMirror message, Supplier<? extends NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TileEntity te;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (te = world.func_175625_s(message.mirrorPos)) instanceof MagicMirrorBaseTileEntity) {
                ((MagicMirrorBaseTileEntity)te).getModifiers().stream().filter(modifier -> modifier instanceof ArmorMagicMirrorTileEntityModifier).findFirst().ifPresent(modifier -> message.armor.swap((ArmorMagicMirrorTileEntityModifier)modifier));
            }
        }));
        ctx.setPacketHandled(true);
    }

    public static void onMessageSwapPlayer(MessageSwapPlayer message, Supplier<? extends NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(message.entityId)) instanceof PlayerEntity) {
                message.armor.swap((PlayerEntity)entity);
                entity.func_184185_a(SoundEvents.field_187534_aX, 0.8f, 0.4f);
                Random random = new Random();
                for (int i = 0; i < 64; ++i) {
                    entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197599_J, entity.func_226277_ct_() + random.nextGaussian() / 4.0, entity.func_226278_cu_() + 2.0 * random.nextDouble(), entity.func_226281_cx_() + random.nextGaussian() / 4.0, random.nextGaussian() / 2.0, random.nextDouble(), random.nextGaussian() / 2.0);
                }
            }
        }));
        ctx.setPacketHandled(true);
    }

    public static class MessageSwapPlayer
    extends MessageSwap {
        int entityId;

        public MessageSwapPlayer() {
        }

        MessageSwapPlayer(ArmorMagicMirrorTileEntityModifier armorModifier, PlayerEntity player) {
            super((Iterable<ItemStack>)armorModifier.getReplacementArmor().replacementInventory);
            this.entityId = player.func_145782_y();
        }

        public static MessageSwapPlayer decode(PacketBuffer buf) {
            MessageSwapPlayer result = new MessageSwapPlayer();
            result.decodeArmor(buf);
            result.entityId = buf.readInt();
            return result;
        }

        public void encode(PacketBuffer buf) {
            this.encodeArmor(buf);
            buf.writeInt(this.entityId);
        }
    }

    public static class MessageSwapMirror
    extends MessageSwap {
        BlockPos mirrorPos;

        public MessageSwapMirror() {
        }

        MessageSwapMirror(MagicMirrorBaseTileEntity magicMirrorBase, PlayerEntity player) {
            super(player.func_184193_aE());
            this.mirrorPos = magicMirrorBase.func_174877_v();
        }

        public static MessageSwapMirror decode(PacketBuffer buf) {
            MessageSwapMirror result = new MessageSwapMirror();
            result.decodeArmor(buf);
            result.mirrorPos = buf.func_179259_c();
            return result;
        }

        public void encode(PacketBuffer buf) {
            this.encodeArmor(buf);
            buf.func_179255_a(this.mirrorPos);
        }
    }

    static class MessageSwap {
        final ReplacementArmor armor;

        MessageSwap() {
            this.armor = new ReplacementArmor();
        }

        MessageSwap(Iterable<ItemStack> armor) {
            this.armor = new ReplacementArmor(armor);
        }

        void decodeArmor(PacketBuffer buf) {
            for (int i = 0; i < 4; ++i) {
                this.armor.set(i, buf.func_150791_c());
            }
        }

        void encodeArmor(PacketBuffer buf) {
            for (ItemStack stack : this.armor.replacementInventory) {
                buf.func_150788_a(stack);
            }
        }
    }

    public static class MessageEquip {
        final int slotIdx;
        final ItemStack armor;
        final BlockPos mirrorPos;

        MessageEquip(BlockPos mirrorPos, int slotIdx, ItemStack armor) {
            this.mirrorPos = mirrorPos;
            this.slotIdx = slotIdx;
            this.armor = armor.func_77946_l();
        }

        public static MessageEquip decode(PacketBuffer buf) {
            return new MessageEquip(buf.func_179259_c(), buf.readInt(), buf.func_150791_c());
        }

        public void encode(PacketBuffer buf) {
            buf.func_179255_a(this.mirrorPos);
            buf.writeInt(this.slotIdx);
            buf.func_150788_a(this.armor);
        }
    }

    public static class ReplacementArmor {
        private final NonNullList<ItemStack> replacementInventory;

        ReplacementArmor() {
            this.replacementInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        }

        ReplacementArmor(Iterable<ItemStack> armor) {
            this.replacementInventory = NonNullList.func_191196_a();
            armor.forEach(arg_0 -> this.replacementInventory.add(arg_0));
        }

        boolean isEmpty(int i) {
            return i >= 0 && i < this.replacementInventory.size() && ((ItemStack)this.replacementInventory.get(i)).func_190926_b();
        }

        void set(int i, ItemStack stack) {
            this.replacementInventory.set(i, (Object)stack);
        }

        public void swap(NonNullList<ItemStack> inventory) {
            for (int i = 0; i < 4; ++i) {
                ItemStack original = (ItemStack)inventory.get(i);
                ItemStack replacement = (ItemStack)this.replacementInventory.get(i);
                if (EnchantmentHelper.func_190938_b((ItemStack)original) || EnchantmentHelper.func_190938_b((ItemStack)replacement)) continue;
                this.replacementInventory.set(i, (Object)original);
                inventory.set(i, (Object)replacement);
            }
        }

        void swap(PlayerEntity player) {
            for (int i = 0; i < 4; ++i) {
                ItemStack playerArmor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
                ItemStack replacement = (ItemStack)this.replacementInventory.get(i);
                if (EnchantmentHelper.func_190938_b((ItemStack)playerArmor) || EnchantmentHelper.func_190938_b((ItemStack)replacement)) continue;
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-2, i + 36, replacement));
                }
                this.replacementInventory.set(i, (Object)playerArmor);
                player.field_71071_by.field_70460_b.set(i, (Object)replacement);
            }
        }

        CompoundNBT write(CompoundNBT nbt) {
            ItemStackHelper.func_191281_a((CompoundNBT)nbt, this.replacementInventory, (boolean)true);
            return nbt;
        }

        void read(CompoundNBT nbt) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.replacementInventory);
        }

        void spawn(World world, BlockPos pos) {
            for (ItemStack itemStack : this.replacementInventory) {
                if (itemStack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
                itemStack.func_190920_e(0);
            }
        }

        void swap(ArmorMagicMirrorTileEntityModifier modifier) {
            MagicMirrorMod.LOGGER.info("Swapping with mirror");
            this.swap(((ArmorMagicMirrorTileEntityModifier)modifier).getReplacementArmor().replacementInventory);
        }
    }
}

