/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers;

import com.google.common.collect.Lists;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.BannerReflectionModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.BannerReflectionModifierClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BannerMagicMirrorTileEntityModifier
extends MagicMirrorTileEntityModifier {
    private DyeColor baseColor = DyeColor.BLACK;
    @Nullable
    private CompoundNBT bannerNBT;
    @Nullable
    private ITextComponent name;
    @Nullable
    private BannerReflectionModifier reflectionModifier;

    public BannerMagicMirrorTileEntityModifier(MagicMirrorModifier modifier) {
        super(modifier);
    }

    public BannerMagicMirrorTileEntityModifier(MagicMirrorModifier modifier, DyeColor baseColor, @Nullable CompoundNBT bannerNBT, @Nullable ITextComponent name) {
        super(modifier);
        this.baseColor = baseColor;
        this.bannerNBT = bannerNBT != null ? bannerNBT.func_74737_b() : null;
        this.name = name;
    }

    @Override
    public void remove(World world, BlockPos pos) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(String.format("minecraft:%s_banner", this.baseColor.func_176762_d())));
        ItemStack itemStack = new ItemStack((IItemProvider)block);
        if (this.bannerNBT != null) {
            itemStack.func_196082_o().func_218657_a("BlockEntityTag", (INBT)this.bannerNBT);
        }
        if (this.name != null) {
            itemStack.func_200302_a(this.name);
        }
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        super.write(nbt);
        nbt.func_74768_a("BannerColor", this.baseColor.func_196059_a());
        if (this.bannerNBT != null) {
            nbt.func_218657_a("BannerData", (INBT)this.bannerNBT.func_74737_b());
        }
        nbt.func_74778_a("BannerName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        return nbt;
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.baseColor = DyeColor.func_196056_a((int)nbt.func_74762_e("BannerColor"));
        CompoundNBT bannerData = nbt.func_74775_l("BannerData");
        if (!bannerData.isEmpty()) {
            this.bannerNBT = bannerData.func_74737_b();
        }
        this.name = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("BannerName"));
    }

    @Override
    public void activate(MagicMirrorBaseTileEntity tileEntity) {
        Reflection reflection = tileEntity.getReflection();
        if (reflection != null) {
            ArrayList patternList = Lists.newArrayList();
            patternList.add(Pair.of((Object)BannerPattern.BASE, (Object)this.baseColor));
            if (this.bannerNBT != null) {
                ListNBT patterns = this.bannerNBT.func_150295_c("Patterns", 10);
                int size = patterns.size();
                for (int i = 0; i < size; ++i) {
                    CompoundNBT pattern = patterns.func_150305_b(i);
                    String patternHash = pattern.func_74779_i("Pattern");
                    Optional<BannerPattern> bannerPattern = Arrays.stream(BannerPattern.values()).filter(p -> p.func_190993_b().equals(patternHash)).findFirst();
                    if (!bannerPattern.isPresent()) continue;
                    DyeColor bannerPatternColor = DyeColor.func_196056_a((int)pattern.func_74762_e("Color"));
                    patternList.add(Pair.of((Object)bannerPattern.get(), (Object)bannerPatternColor));
                }
            }
            this.reflectionModifier = BannerMagicMirrorTileEntityModifier.createReflectionModifier(patternList);
            reflection.addModifier(this.reflectionModifier);
        }
    }

    private static BannerReflectionModifier createReflectionModifier(List<? extends Pair<BannerPattern, DyeColor>> patternList) {
        return (BannerReflectionModifier)DistExecutor.runForDist(() -> () -> new BannerReflectionModifierClient(patternList), () -> () -> new BannerReflectionModifier(patternList));
    }

    @Override
    public void deactivate(MagicMirrorBaseTileEntity tileEntity) {
        Reflection reflection;
        if (this.reflectionModifier != null && (reflection = tileEntity.getReflection()) != null) {
            reflection.removeModifier(this.reflectionModifier);
        }
    }

    @Override
    public boolean tryPlayerActivate(MagicMirrorBaseTileEntity tileEntity, PlayerEntity playerIn, Hand hand) {
        return false;
    }
}

