/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tomboshoven.minecraft.magicmirror.blocks.MagicMirrorBlock;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.ReflectionClient;
import com.tomboshoven.minecraft.magicmirror.reflection.ReflectionClientUpdater;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class TileEntityMagicMirrorRenderer
extends TileEntityRenderer<MagicMirrorBaseTileEntity> {
    private static final double MAX_HORIZONTAL_DISTANCE_SQ = 64.0;
    private static final double MAX_VERTICAL_DISTANCE_SQ = 9.0;

    TileEntityMagicMirrorRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MagicMirrorBaseTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Entity reflected;
        Reflection reflection = tileEntityIn.getReflection();
        if (reflection instanceof ReflectionClient && (reflected = reflection.getReflectedEntity()) != null) {
            MagicMirrorBlock.EnumPartType part = tileEntityIn.getPart();
            Direction facing = tileEntityIn.getFacing();
            BlockPos tePos = tileEntityIn.func_174877_v();
            Vector3d reflectedPos = reflected.func_213303_ch().func_72441_c(0.5, 0.5, 0.5);
            Vector3d distanceVector = reflectedPos.func_178786_a((double)tePos.func_177958_n(), (double)tePos.func_177956_o(), (double)tePos.func_177952_p());
            ReflectionClientUpdater.markViewed((ReflectionClient)reflection);
            TileEntityMagicMirrorRenderer.renderReflection((ReflectionClient)reflection, matrixStackIn, bufferIn, part, facing, distanceVector);
        }
    }

    private static void renderReflection(ReflectionClient reflection, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, MagicMirrorBlock.EnumPartType part, Direction facing, Vector3d distance) {
        double horizontalDistanceSq = distance.field_72450_a * distance.field_72450_a + distance.field_72449_c * distance.field_72449_c;
        double verticalDistanceSq = distance.field_72448_b * distance.field_72448_b;
        float reflectionAlpha = Math.max(0.0f, Math.min(1.0f, 1.2f - (float)(horizontalDistanceSq / 64.0) - (float)(verticalDistanceSq / 9.0)));
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(facing.func_185119_l()));
        matrixStack.func_227861_a_(0.0, 0.0, -0.4);
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(reflection.getRenderType());
        float texTop = part == MagicMirrorBlock.EnumPartType.TOP ? 0.0f : 0.5f;
        float texBottom = part == MagicMirrorBlock.EnumPartType.TOP ? 0.5f : 1.0f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, -0.5f, -0.5f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, reflectionAlpha).func_225583_a_(0.0f, texBottom).func_181675_d();
        buffer.func_227888_a_(matrix, 0.5f, -0.5f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, reflectionAlpha).func_225583_a_(1.0f, texBottom).func_181675_d();
        buffer.func_227888_a_(matrix, 0.5f, 0.5f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, reflectionAlpha).func_225583_a_(1.0f, texTop).func_181675_d();
        buffer.func_227888_a_(matrix, -0.5f, 0.5f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, reflectionAlpha).func_225583_a_(0.0f, texTop).func_181675_d();
    }
}

