/*
 * Decompiled with CFR 0.152.
 */
package com.neronix17.mancatcher;

import com.neronix17.mancatcher.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSack
extends Item {
    public ItemSack(Item.Properties properties) {
        super(properties);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemSack.containsEntity(stack) ? 1 : 16;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        Hand hand = Hand.MAIN_HAND;
        ItemStack stack = player.func_184614_ca();
        if (player.func_130014_f_().field_72995_K || !ItemSack.containsEntity(stack)) {
            return ActionResultType.FAIL;
        }
        Entity entity = ItemSack.getEntityFromStack(stack, player.field_70170_p, true);
        BlockPos blockPos = context.func_195995_a();
        entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)(blockPos.func_177956_o() + 1), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        stack.func_77982_d(null);
        stack.func_190918_g(1);
        ItemStack newStack = new ItemStack((IItemProvider)ModItems.EMPTY_SACK);
        player.func_184611_a(hand, newStack);
        player.field_70170_p.func_217376_c(entity);
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemSack.containsEntity(stack) && !ItemSack.getID(stack).isEmpty()) {
            String s0 = "entity." + ItemSack.getID(stack);
            String s1 = s0.replace(':', '.');
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)s1, (Object[])new Object[0])));
            tooltip.add((ITextComponent)new StringTextComponent("Health: " + stack.func_77978_p().func_74769_h("Health")));
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (!ItemSack.containsEntity(stack)) {
            return new TranslationTextComponent(super.func_77667_c(stack) + ".name", new Object[0]);
        }
        String s0 = "entity." + ItemSack.getID(stack);
        String s1 = s0.replace(':', '.');
        return new TranslationTextComponent(I18n.func_135052_a((String)(super.func_77667_c(stack) + ".name"), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)s1, (Object[])new Object[0]), new Object[0]);
    }

    public static boolean containsEntity(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("entity");
    }

    public static String getID(ItemStack stack) {
        return stack.func_196082_o().func_74779_i("entity");
    }

    public static boolean isBlacklisted(String entity) {
        return false;
    }

    public static Entity getEntityFromStack(ItemStack stack, World world, boolean withInfo) {
        Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("entity")))).func_200721_a(world);
        if (withInfo) {
            entity.func_70020_e(stack.func_77978_p());
        }
        return entity;
    }
}

