/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import ichttt.mods.mcpaint.client.gui.DrawScreenHelper;
import ichttt.mods.mcpaint.client.gui.IDrawGuiCallback;
import ichttt.mods.mcpaint.client.gui.button.GuiButtonTextToggle;
import ichttt.mods.mcpaint.client.gui.button.GuiColorButton;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class DrawScreen
extends Screen
implements Slider.ISlider,
IDrawGuiCallback {
    private static final int PICTURE_START_LEFT = 6;
    private static final int PICTURE_START_TOP = 9;
    public static final ResourceLocation BACKGROUND = new ResourceLocation("mcpaint", "textures/gui/setup.png");
    private static final int xSize = 176;
    private static final int ySize = 166;
    private static final int toolXSize = 80;
    private static final int toolYSize = 95;
    private static final int sizeXSize = 80;
    private static final int sizeYSize = 34;
    private final DrawScreenHelper helper;
    private int guiLeft;
    private int guiTop;
    private Button undo;
    private Button redo;
    private Button lessSize;
    private Button moreSize;
    private final List<GuiButtonTextToggle> textToggleList = new ArrayList<GuiButtonTextToggle>();
    private Slider redSlider;
    private Slider blueSlider;
    private Slider greenSlider;
    private Slider alphaSlider;
    private boolean updating;

    public DrawScreen(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, Direction facing, BlockState state) {
        super((ITextComponent)new TranslationTextComponent("mcpaint.drawgui"));
        this.helper = new DrawScreenHelper(canvas, prevImages, pos, facing, state, this);
    }

    public DrawScreen(byte scaleFactor, BlockPos pos, Direction facing, BlockState state) {
        super((ITextComponent)new TranslationTextComponent("mcpaint.drawgui"));
        this.helper = new DrawScreenHelper(scaleFactor, pos, facing, state, this);
    }

    public void func_231160_c_() {
        this.textToggleList.clear();
        this.guiLeft = (this.field_230708_k_ - 176) / 2;
        this.guiTop = (this.field_230709_l_ - 166) / 2;
        Button saveImage = new Button(this.guiLeft + 176, this.guiTop + 96, 80, 20, (ITextComponent)new TranslationTextComponent("mcpaint.gui.export"), button -> this.helper.saveImage());
        Button rotateRight = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22 + 22, 36, 20, (ITextComponent)new TranslationTextComponent("mcpaint.gui.rright"), button -> this.helper.rotateRight());
        Button rotateLeft = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22 + 22, 36, 20, (ITextComponent)new TranslationTextComponent("mcpaint.gui.rleft"), button -> this.helper.rotateLeft());
        this.redo = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22, 36, 20, (ITextComponent)new TranslationTextComponent("mcpaint.gui.redo"), button -> this.helper.redo());
        this.undo = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22, 36, 20, (ITextComponent)new TranslationTextComponent("mcpaint.gui.undo"), button -> this.helper.undo());
        GuiButtonTextToggle pickColor = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22, 36, 20, EnumDrawType.PICK_COLOR, this::handleToolButton);
        GuiButtonTextToggle erase = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5 + 22, 36, 20, EnumDrawType.ERASER, this::handleToolButton);
        GuiButtonTextToggle fill = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5, 36, 20, EnumDrawType.FILL, this::handleToolButton);
        GuiButtonTextToggle pencil = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5, 36, 20, EnumDrawType.PENCIL, this::handleToolButton);
        this.moreSize = new Button(this.guiLeft - 80 + 3 + 55, this.guiTop + 95 + 5, 20, 20, (ITextComponent)new StringTextComponent(">"), button -> {
            ++this.helper.toolSize;
            this.handleSizeChanged();
        });
        this.lessSize = new Button(this.guiLeft - 80 + 3, this.guiTop + 95 + 5, 20, 20, (ITextComponent)new StringTextComponent("<"), button -> {
            --this.helper.toolSize;
            this.handleSizeChanged();
        });
        Button done = new Button(this.guiLeft + 88 - 100, this.guiTop + 166 + 20, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.helper.saveAndClose());
        GuiColorButton black = new GuiColorButton(0, this.guiLeft + 137, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton white = new GuiColorButton(1, this.guiLeft + 137 + 18, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton gray = new GuiColorButton(2, this.guiLeft + 137, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton red = new GuiColorButton(3, this.guiLeft + 137 + 18, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton orange = new GuiColorButton(4, this.guiLeft + 137, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton yellow = new GuiColorButton(5, this.guiLeft + 137 + 18, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton lime = new GuiColorButton(6, this.guiLeft + 137, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton green = new GuiColorButton(7, this.guiLeft + 137 + 18, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton lightBlue = new GuiColorButton(8, this.guiLeft + 137, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton darkBlue = new GuiColorButton(9, this.guiLeft + 137 + 18, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton purple = new GuiColorButton(10, this.guiLeft + 137, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton pink = new GuiColorButton(11, this.guiLeft + 137 + 18, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        this.redSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 4, "mcpaint.gui.red");
        this.greenSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 26, "mcpaint.gui.green");
        this.blueSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 48, "mcpaint.gui.blue");
        this.alphaSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 70, "mcpaint.gui.alpha");
        this.func_230480_a_((Widget)saveImage);
        this.func_230480_a_((Widget)rotateRight);
        this.func_230480_a_((Widget)rotateLeft);
        this.func_230480_a_((Widget)this.redo);
        this.func_230480_a_((Widget)this.undo);
        this.func_230480_a_((Widget)pickColor);
        this.func_230480_a_((Widget)erase);
        this.func_230480_a_((Widget)fill);
        this.func_230480_a_((Widget)pencil);
        this.func_230480_a_((Widget)done);
        this.func_230480_a_((Widget)black);
        this.func_230480_a_((Widget)white);
        this.func_230480_a_((Widget)gray);
        this.func_230480_a_((Widget)red);
        this.func_230480_a_((Widget)orange);
        this.func_230480_a_((Widget)yellow);
        this.func_230480_a_((Widget)lime);
        this.func_230480_a_((Widget)green);
        this.func_230480_a_((Widget)lightBlue);
        this.func_230480_a_((Widget)darkBlue);
        this.func_230480_a_((Widget)purple);
        this.func_230480_a_((Widget)pink);
        this.func_230480_a_((Widget)this.redSlider);
        this.func_230480_a_((Widget)this.greenSlider);
        this.func_230480_a_((Widget)this.blueSlider);
        this.func_230480_a_((Widget)this.alphaSlider);
        for (Widget button2 : this.field_230710_m_) {
            if (!(button2 instanceof GuiButtonTextToggle)) continue;
            this.textToggleList.add((GuiButtonTextToggle)button2);
        }
        pencil.func_230982_a_(0.0, 0.0);
        this.lessSize.func_230982_a_(0.0, 0.0);
        black.func_230982_a_(0.0, 0.0);
        this.redo.func_230982_a_(0.0, 0.0);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, 176, 166);
        this.func_238474_b_(stack, this.guiLeft + 176, this.guiTop, 176, 0, 80, 95);
        this.func_238474_b_(stack, this.guiLeft - 80, this.guiTop, 176, 0, 80, 95);
        if (this.helper.hasSizeWindow()) {
            this.func_238474_b_(stack, this.guiLeft - 80, this.guiTop + 95 + 1, 176, 96, 80, 34);
            DrawScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)(this.helper.toolSize + ""), (int)(this.guiLeft - 80 + 40), (int)(this.guiTop + 95 + 11), (int)Color.WHITE.getRGB());
        }
        this.helper.renderBackgroundBlock(stack, this.guiLeft + 6, this.guiTop + 9);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        DrawScreen.func_238467_a_((MatrixStack)stack, (int)(this.guiLeft + 138), (int)(this.guiTop + 125), (int)(this.guiLeft + 138 + 32), (int)(this.guiTop + 125 + 32), (int)this.helper.color.getRGB());
        int offsetMouseX = this.offsetMouseX(mouseX);
        int offsetMouseY = this.offsetMouseY(mouseY);
        boolean drawSelect = this.isInPicture(offsetMouseX, offsetMouseY) && this.helper.activeDrawType() != EnumDrawType.PICK_COLOR;
        int[][] toDraw = this.helper.getBasePicture();
        if (drawSelect) {
            int pixelPosX = offsetMouseX / this.helper.currentState().scaleFactor;
            int pixelPosY = offsetMouseY / this.helper.currentState().scaleFactor;
            toDraw = MCPaintUtil.copyOf(toDraw);
            this.helper.activeDrawType().draw(toDraw, this.helper.color, pixelPosX, pixelPosY, this.helper.toolSize);
        }
        this.helper.renderImage(stack, this.guiLeft + 6, this.guiTop + 9, toDraw);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.helper.handleMouseClick(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double v2, double v3) {
        if (this.helper.handleMouseDragged(mouseX, mouseY, clickedMouseButton)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, v2, v3);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.helper.handleMouseReleased(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keyCode, int i1, int i2) {
        if (keyCode == 90 && InputMappings.func_216506_a((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)341)) {
            if (InputMappings.func_216506_a((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)340)) {
                this.helper.redo();
            } else {
                this.helper.undo();
            }
            return true;
        }
        return super.func_231046_a_(keyCode, i1, i2);
    }

    private void handleColorChange(Color color) {
        this.helper.color = color;
        this.updateSliders();
    }

    protected void handleToolButton(Button button) {
        for (GuiButtonTextToggle toggleButton : this.textToggleList) {
            boolean toggled;
            toggleButton.toggled = toggled = toggleButton == button;
            if (!toggled) continue;
            boolean hadSizeWindow = this.helper.switchToolButton(toggleButton.type);
            if (this.helper.activeDrawType().hasSizeRegulator && !hadSizeWindow) {
                this.func_230480_a_((Widget)this.moreSize);
                this.func_230480_a_((Widget)this.lessSize);
                continue;
            }
            if (this.helper.activeDrawType().hasSizeRegulator || !hadSizeWindow) continue;
            this.field_230710_m_.remove(this.moreSize);
            this.field_230710_m_.remove(this.lessSize);
        }
    }

    public void func_231164_f_() {
        this.helper.onClose();
    }

    private Slider makeSlider(int xPos, int yPos, String key) {
        return new Slider(xPos, yPos, 74, 20, (ITextComponent)new TranslationTextComponent(key), StringTextComponent.field_240750_d_, 0.0, 255.0, 0.0, false, true, null, (Slider.ISlider)this);
    }

    private void handleSizeChanged() {
        if (this.helper.toolSize >= 10) {
            this.helper.toolSize = 10;
            this.moreSize.field_230693_o_ = false;
        } else {
            this.moreSize.field_230693_o_ = true;
        }
        if (this.helper.toolSize <= 1) {
            this.helper.toolSize = 1;
            this.lessSize.field_230693_o_ = false;
        } else {
            this.lessSize.field_230693_o_ = true;
        }
    }

    public void onChangeSliderValue(Slider slider) {
        if (this.updating) {
            return;
        }
        this.helper.color = new Color(this.redSlider.getValueInt(), this.greenSlider.getValueInt(), this.blueSlider.getValueInt(), this.alphaSlider.getValueInt());
    }

    @Override
    public void updateSliders() {
        Color color = this.helper.color;
        this.redSlider.setValue((double)color.getRed());
        this.blueSlider.setValue((double)color.getBlue());
        this.greenSlider.setValue((double)color.getGreen());
        this.alphaSlider.setValue((double)color.getAlpha());
        this.updating = true;
        this.redSlider.updateSlider();
        this.blueSlider.updateSlider();
        this.greenSlider.updateSlider();
        this.alphaSlider.updateSlider();
        this.updating = false;
    }

    @Override
    public void updateUndoRedoButton(boolean hasUndo, boolean hasRedo) {
        this.undo.field_230693_o_ = hasUndo;
        this.redo.field_230693_o_ = hasRedo;
    }

    @Override
    public boolean isInPicture(int offsetMouseX, int offsetMouseY) {
        PictureState currentState = this.helper.currentState();
        return offsetMouseX >= 0 && offsetMouseX < currentState.picture.length * currentState.scaleFactor && offsetMouseY >= 0 && offsetMouseY < currentState.picture.length * currentState.scaleFactor;
    }

    @Override
    public int offsetMouseX(int mouseX) {
        return mouseX - this.guiLeft - 6;
    }

    @Override
    public int offsetMouseY(int mouseY) {
        return mouseY - this.guiTop - 9;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

