/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.block;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesFeature;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftearthmod.MinecraftEarthModModElements;
import net.minecraftearthmod.procedures.MudUpdateTickProcedure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@MinecraftEarthModModElements.ModElement.Tag
public class MudBlock
extends MinecraftEarthModModElements.ModElement {
    @ObjectHolder(value="minecraft_earth_mod:mud")
    public static final FlowingFluidBlock block = null;
    @ObjectHolder(value="minecraft_earth_mod:mud_bucket")
    public static final Item bucket = null;
    public static FlowingFluid flowing = null;
    public static FlowingFluid still = null;
    private ForgeFlowingFluid.Properties fluidproperties = null;

    public MudBlock(MinecraftEarthModModElements instance) {
        super(instance, 4);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new FluidRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Fluid)still, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)flowing, (RenderType)RenderType.func_228645_f_());
    }

    @Override
    public void initElements() {
        this.fluidproperties = new ForgeFlowingFluid.Properties(() -> still, () -> flowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation("minecraft_earth_mod:blocks/mud"), (ResourceLocation)new ResourceLocation("minecraft_earth_mod:blocks/mud")).luminosity(0).density(1000).viscosity(2005)).bucket(() -> bucket).block(() -> block);
        still = (FlowingFluid)new ForgeFlowingFluid.Source(this.fluidproperties).setRegistryName("mud");
        flowing = (FlowingFluid)new ForgeFlowingFluid.Flowing(this.fluidproperties).setRegistryName("mud_flowing");
        this.elements.blocks.add(() -> (Block)new FlowingFluidBlock(still, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h)){

            public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean moving) {
                super.func_220082_b(state, world, pos, oldState, moving);
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("x", x);
                $_dependencies.put("y", y);
                $_dependencies.put("z", z);
                $_dependencies.put("world", world);
                MudUpdateTickProcedure.executeProcedure($_dependencies);
            }

            public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
                super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("x", x);
                $_dependencies.put("y", y);
                $_dependencies.put("z", z);
                $_dependencies.put("world", world);
                MudUpdateTickProcedure.executeProcedure($_dependencies);
            }

            public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
                super.func_225534_a_(state, world, pos, random);
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("x", x);
                $_dependencies.put("y", y);
                $_dependencies.put("z", z);
                $_dependencies.put("world", world);
                MudUpdateTickProcedure.executeProcedure($_dependencies);
                world.func_205220_G_().func_205360_a(new BlockPos(x, y, z), (Object)this, 10);
            }
        }.setRegistryName("mud"));
        this.elements.items.add(() -> (Item)new BucketItem((Fluid)still, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)).setRegistryName("mud_bucket"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("minecraft_earth_mod:plains_build_plate").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("minecraft_earth_mod:forest_build_plate").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("swamp").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("jungle").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> new LakesFeature(BlockStateFeatureConfig.field_236455_a_){

            public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
                RegistryKey dimensionType = world.func_201672_e().func_234923_W_();
                boolean dimensionCriteria = false;
                if (dimensionType == World.field_234918_g_) {
                    dimensionCriteria = true;
                }
                if (dimensionType == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("minecraft_earth_mod:minecraft_earth_dimension"))) {
                    dimensionCriteria = true;
                }
                if (!dimensionCriteria) {
                    return false;
                }
                return super.func_241855_a(world, generator, rand, pos, config);
            }
        }.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(block.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(1))));
    }

    private static class FluidRegisterHandler {
        private FluidRegisterHandler() {
        }

        @SubscribeEvent
        public void registerFluids(RegistryEvent.Register<Fluid> event) {
            event.getRegistry().register((IForgeRegistryEntry)still);
            event.getRegistry().register((IForgeRegistryEntry)flowing);
        }
    }
}

