/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.entity;

import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftearthmod.MinecraftEarthModModElements;
import net.minecraftearthmod.item.BoneshardItem;
import net.minecraftearthmod.itemgroup.DerecEarthMobsSpawnEggsItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MinecraftEarthModModElements.ModElement.Tag
public class BoneSpiderEntity
extends MinecraftEarthModModElements.ModElement {
    public static EntityType entity = null;

    public BoneSpiderEntity(MinecraftEarthModModElements instance) {
        super(instance, 51);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(1.4f, 0.9f).func_206830_a("bone_spider").setRegistryName("bone_spider");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -16777216, -1, new Item.Properties().func_200916_a(DerecEarthMobsSpawnEggsItemGroup.tab)).setRegistryName("bone_spider_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("plains").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("jungle").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("jungle_hills").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("savanna").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 1, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        DungeonHooks.addDungeonMob((EntityType)entity, (int)180);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 32.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.1);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class CustomEntity
    extends MonsterEntity
    implements IRangedAttackMob {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 12;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ServerPlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(5, (Goal)new RestrictSunGoal((CreatureEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

                public boolean func_75253_b() {
                    return this.func_75250_a();
                }
            });
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223224_c_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.skeleton.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.death"));
        }

        public void func_82196_d(LivingEntity target, float flval) {
            BoneshardItem.shoot((LivingEntity)this, target);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, (EntityModel)new SpiderModel(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("minecraft_earth_mod:textures/bonespider.png");
                }
            });
        }
    }
}

