/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftearthmod.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftearthmod.MinecraftEarthModModElements;
import net.minecraftearthmod.entity.MuddyPigEntity;
import net.minecraftearthmod.procedures.CheckExperimentalProcedure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@MinecraftEarthModModElements.ModElement.Tag
public class LobberZombieEntity
extends MinecraftEarthModModElements.ModElement {
    public static EntityType entity = null;
    @ObjectHolder(value="minecraft_earth_mod:entitybulletlobber_zombie")
    public static final EntityType arrow = null;

    public LobberZombieEntity(MinecraftEarthModModElements instance) {
        super(instance, 189);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.9f).func_206830_a("lobber_zombie").setRegistryName("lobber_zombie");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10457804, -16051824, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("lobber_zombie_spawn_egg"));
        this.elements.entities.add(() -> (EntityType)EntityType.Builder.func_220322_a(ArrowCustomEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).setCustomClientFactory(ArrowCustomEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("entitybulletlobber_zombie").setRegistryName("entitybulletlobber_zombie"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("plains").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("desert").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("mountains").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("swamp").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("snowy_tundra").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("beach").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("desert_hills").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("jungle").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("savanna").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 10, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return CheckExperimentalProcedure.executeProcedure((Map<String, Object>)ImmutableMap.of((Object)"world", (Object)world));
        });
        DungeonHooks.addDungeonMob((EntityType)entity, (int)180);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.2);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 20.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
        ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 0.1);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class Modellobberzombie
    extends EntityModel<Entity> {
        private final ModelRenderer Head;
        private final ModelRenderer Body;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;

        public Modellobberzombie() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Head = new ModelRenderer((Model)this);
            this.Head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Head.func_78784_a(0, 0).func_228303_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
            this.Body = new ModelRenderer((Model)this);
            this.Body.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Body.func_78784_a(16, 16).func_228303_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f, false);
            this.RightArm = new ModelRenderer((Model)this);
            this.RightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.setRotationAngle(this.RightArm, -1.5708f, 0.0f, 0.0f);
            this.RightArm.func_78784_a(0, 32).func_228303_a_(-3.0f, -2.0f, -2.0f, 4.0f, 11.0f, 4.0f, 0.25f, false);
            this.LeftArm = new ModelRenderer((Model)this);
            this.LeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.setRotationAngle(this.LeftArm, -1.5708f, 0.0f, 0.0f);
            this.LeftArm.func_78784_a(16, 32).func_228303_a_(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, 0.25f, false);
            this.RightLeg = new ModelRenderer((Model)this);
            this.RightLeg.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.RightLeg.func_78784_a(48, 46).func_228303_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f, false);
            this.LeftLeg = new ModelRenderer((Model)this);
            this.LeftLeg.func_78793_a(1.9f, 12.0f, 0.0f);
            this.LeftLeg.func_78784_a(0, 47).func_228303_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.Head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.Body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
    private static class ArrowCustomEntity
    extends AbstractArrowEntity
    implements IRendersAsItem {
        public ArrowCustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            super(arrow, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, World world) {
            super(type, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, double x, double y, double z, World world) {
            super(type, x, y, z, world);
        }

        public ArrowCustomEntity(EntityType<? extends ArrowCustomEntity> type, LivingEntity entity, World world) {
            super(type, entity, world);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_184543_l() {
            return new ItemStack((IItemProvider)Items.field_151078_bh, 1);
        }

        protected ItemStack func_184550_j() {
            return new ItemStack((IItemProvider)Items.field_151078_bh, 1);
        }
    }

    public static class CustomEntity
    extends MonsterEntity
    implements IRangedAttackMob {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 5;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new RestrictSunGoal((CreatureEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MuddyPigEntity.CustomEntity.class, false, false));
            this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(6, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(8, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

                public boolean func_75253_b() {
                    return this.func_75250_a();
                }
            });
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223223_b_;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie.ambient"));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie.step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.zombie.death"));
        }

        public void func_82196_d(LivingEntity target, float flval) {
            ArrowCustomEntity entityarrow = new ArrowCustomEntity((EntityType<? extends ArrowCustomEntity>)arrow, (LivingEntity)this, this.field_70170_p);
            double d0 = target.func_226278_cu_() + (double)target.func_70047_e() - 1.1;
            double d1 = target.func_226277_ct_() - this.func_226277_ct_();
            double d3 = target.func_226281_cx_() - this.func_226281_cx_();
            entityarrow.func_70186_c(d1, d0 - entityarrow.func_226278_cu_() + (double)MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * (double)0.2f, d3, 1.6f, 12.0f);
            this.field_70170_p.func_217376_c((Entity)entityarrow);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modellobberzombie(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("minecraft_earth_mod:textures/lobberzombie.png");
                }
            });
            RenderingRegistry.registerEntityRenderingHandler((EntityType)arrow, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        }
    }
}

