/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class Util {
    public static ResourceLocation res(String domainAndPath) {
        return new ResourceLocation(domainAndPath);
    }

    public static ResourceLocation res(String domain, String path) {
        return new ResourceLocation(domain, path);
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_190916_E() > 0 && !stack.func_190926_b() && !stack.func_77973_b().equals(Items.field_190931_a);
    }

    public static boolean equalExceptAmount(ItemStack stack1, ItemStack stack2) {
        if (!Util.isValid(stack1) && !Util.isValid(stack2)) {
            return true;
        }
        if (!Util.isValid(stack1) && Util.isValid(stack2)) {
            return false;
        }
        if (Util.isValid(stack1) && !Util.isValid(stack2)) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && (!stack1.func_77942_o() && !stack2.func_77942_o() || stack1.func_77978_p().equals((Object)stack2.func_77978_p()));
    }

    public static void spawnItemForPlayer(EntityLivingBase entity, ItemStack stack) {
        Util.spawnItem(entity.func_130014_f_(), entity.func_174791_d(), stack, 0, 0.0, 0.0, 0.0);
    }

    public static void spawnItem(World world, BlockPos pos, ItemStack stack, double ... speeds) {
        Util.spawnItem(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), stack, speeds);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, double ... speeds) {
        Util.spawnItem(world, pos, stack, 0, speeds);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, int pickupDelay, double ... speeds) {
        if (!Util.isValid(stack)) {
            return;
        }
        EntityItem entityitem = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
        if (speeds.length == 0) {
            entityitem.field_70159_w = Math.random() * 0.4 - 0.2;
            entityitem.field_70181_x = Math.random() * 0.2;
            entityitem.field_70179_y = Math.random() * 0.4 - 0.2;
        } else {
            entityitem.field_70159_w = speeds[0];
            entityitem.field_70181_x = speeds[1];
            entityitem.field_70179_y = speeds[2];
        }
        entityitem.func_174867_a(pickupDelay);
        world.func_72838_d((Entity)entityitem);
    }

    public static int getAvailableSlot(ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (Util.isValid(inventory.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static String translateToLocal(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static ItemStack stateToStack(IBlockState state) {
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public static void setReg(String modid, Block block, String name) {
        block.func_149663_c(modid + "." + name);
        block.setRegistryName(Util.res(modid, name));
    }

    public static void setReg(String modid, Item block, String name) {
        block.func_77655_b(modid + "." + name);
        block.setRegistryName(Util.res(modid, name));
    }

    public static boolean canBeStacked(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void spawnItem(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        Util.spawnItem(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), stack, facing);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, EnumFacing facing) {
        Util.spawnItem(world, pos, stack, 0, facing);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, int pickupDelay, EnumFacing facing) {
        Vec3d v = Util.facingToVector(facing);
        Util.spawnItem(world, pos, stack, pickupDelay, v.field_72450_a / 2.0, v.field_72448_b / 2.0, v.field_72449_c / 2.0);
    }

    public static Vec3d facingToVector(EnumFacing facing) {
        return new Vec3d((double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.X) ? 1 : 0)), (double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.Y) ? 1 : 0)), (double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.Z) ? 1 : 0)));
    }

    public static ResourceLocation resMC(String string) {
        return new ResourceLocation("minecraft", string);
    }

    public static BlockPos[] getBlocksTouching(World world, BlockPos pos) {
        BlockPos[] ret = new BlockPos[EnumFacing.field_82609_l.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = pos.func_177972_a(EnumFacing.field_82609_l[i]);
        }
        return ret;
    }

    public static boolean isMultiblockBuilt(World world, BlockPos realPos, EnumFacing facing, String[][][] multiblock, HashMap<String, BlockWithMeta> table, boolean auto) {
        block7: {
            BlockPos center;
            block6: {
                center = Util.getMyPosition(facing, multiblock);
                if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) break block6;
                for (int y = 0; y < multiblock.length; ++y) {
                    for (int x = 0; x < multiblock[y].length; ++x) {
                        for (int z = 0; z < multiblock[y][x].length; ++z) {
                            if (multiblock[y][x][z] == null || multiblock[y][x][z] == "00" || Util.checkPos(world, realPos, center, facing, multiblock[y][x][z], x, y, z, table, auto)) continue;
                            return false;
                        }
                    }
                }
                break block7;
            }
            if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) break block7;
            for (int y = 0; y < multiblock.length; ++y) {
                for (int z = 0; z < multiblock[y].length; ++z) {
                    for (int x = 0; x < multiblock[y][z].length; ++x) {
                        if (multiblock[y][z][x] == null || multiblock[y][z][x] == "00" || Util.checkPos(world, realPos, center, facing, multiblock[y][z][x], x, y, z, table, auto)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean checkPos(World world, BlockPos realPos, BlockPos centre, EnumFacing facing, String mbs, int x, int y, int z, HashMap<String, BlockWithMeta> table, boolean isAutomaticMultiblocks) {
        boolean isCorrect;
        BlockPos thispos = centre.func_177973_b((Vec3i)new BlockPos(x, y, z));
        if (facing == EnumFacing.EAST) {
            thispos = new BlockPos(-thispos.func_177958_n(), thispos.func_177956_o(), thispos.func_177952_p());
        }
        if (facing == EnumFacing.WEST) {
            thispos = new BlockPos(thispos.func_177958_n(), thispos.func_177956_o(), -thispos.func_177952_p());
        }
        if (facing == EnumFacing.SOUTH) {
            thispos = new BlockPos(-thispos.func_177958_n(), thispos.func_177956_o(), -thispos.func_177952_p());
        }
        BlockWithMeta tableEntry = table.get(mbs);
        IBlockState state = world.func_180495_p(realPos.func_177973_b((Vec3i)thispos));
        boolean bl = isCorrect = tableEntry.block == state.func_177230_c() && Util.hasCorrectMeta(tableEntry.block, tableEntry.meta, tableEntry.block.func_176201_c(state), tableEntry.inverse);
        if (!isCorrect && isAutomaticMultiblocks) {
            if (tableEntry.meta != -1) {
                world.func_180501_a(realPos.func_177973_b((Vec3i)thispos), tableEntry.block.func_176203_a(tableEntry.inverse ? (tableEntry.meta != 0 ? 0 : tableEntry.meta) : tableEntry.meta), 2);
            } else {
                world.func_180501_a(realPos.func_177973_b((Vec3i)thispos), tableEntry.block.func_176223_P(), 2);
            }
            return true;
        }
        return isCorrect;
    }

    public static boolean hasCorrectMeta(Block block, int requiredMeta, int meta, boolean inverse) {
        return requiredMeta == -1 || (inverse ? meta != requiredMeta : meta == requiredMeta);
    }

    public static BlockPos getMyPosition(EnumFacing facing, String[][][] multiblock) {
        int y;
        if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            for (y = 0; y < multiblock.length; ++y) {
                for (int x = 0; x < multiblock[y].length; ++x) {
                    for (int z = 0; z < multiblock[y][x].length; ++z) {
                        if (multiblock[y][x][z] != "00") continue;
                        return new BlockPos(x, y, z);
                    }
                }
            }
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            for (y = 0; y < multiblock.length; ++y) {
                for (int z = 0; z < multiblock[y].length; ++z) {
                    for (int x = 0; x < multiblock[y][z].length; ++x) {
                        if (multiblock[y][z][x] != "00") continue;
                        return new BlockPos(x, y, z);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isVanillaFluid(Block in) {
        return in == Blocks.field_150355_j || in == Blocks.field_150358_i || in == Blocks.field_150353_l || in == Blocks.field_150356_k;
    }

    public static FluidStack vanillaFluidBlockToFluidStack(Block in) {
        if (in == Blocks.field_150355_j || in == Blocks.field_150358_i) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (in == Blocks.field_150353_l || in == Blocks.field_150356_k) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public static List<ItemStack> toItemStackList(Block[] blocks) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (Block block : blocks) {
            list.add(new ItemStack(block));
        }
        return list;
    }

    public static Item getRegisteredItem(String name) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        if (item == null) {
            throw new IllegalStateException("Invalid Item requested: " + name);
        }
        return item;
    }

    public static Block getRegisteredBlock(String name) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
        if (block == null) {
            throw new IllegalStateException("Invalid Block requested: " + name);
        }
        return block;
    }

    public static Block blockAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static JsonElement readJson(String resource, boolean ... internal) throws IOException {
        Gson gson = new Gson();
        InputStream in = internal.length > 0 && internal[0] ? Object.class.getResourceAsStream(resource) : new FileInputStream(new File(resource));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        return je;
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment ench) {
        if (!stack.func_77948_v()) {
            return false;
        }
        NBTTagList enchs = stack.func_77986_q();
        for (NBTBase nbtBase : enchs) {
            if (((NBTTagCompound)nbtBase).func_74765_d("id") != Enchantment.func_185258_b((Enchantment)ench)) continue;
            return true;
        }
        return false;
    }

    public static boolean timeConstraint(long totalWorldTime, int n) {
        String str = totalWorldTime + "";
        return str.charAt(str.length() - n) == '0';
    }

    public static boolean equalNBT(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77942_o() && !stack2.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() != stack2.func_77942_o()) {
            return false;
        }
        return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
    }

    public static EnumFacing sideOf(BlockPos pos, BlockPos fromPos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!pos.func_177972_a(face).equals((Object)fromPos)) continue;
            return face;
        }
        return null;
    }

    public static ItemStack[] deserializeArrayOfItemStacks(JsonArray inputsArray) {
        ItemStack[] ret = new ItemStack[inputsArray.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ShapedRecipes.func_192405_a((JsonObject)inputsArray.get(i).getAsJsonObject(), (boolean)true);
        }
        return ret;
    }

    public static void drawText(FontRenderer fontRenderer, String string, int x, int y, int color, boolean shadow) {
        if (shadow) {
            fontRenderer.func_175063_a(string, (float)(1 + x), (float)(1 + y), color);
        } else {
            fontRenderer.func_78276_b(string, 1 + x, 1 + y, color);
        }
    }

    public static void drawTextCentered(FontRenderer fontRenderer, String string, int x, int y, int w, int h, int color, boolean shadow) {
        int sw = fontRenderer.func_78256_a(string);
        int sh = fontRenderer.func_78267_b(string, 9999999);
        if (shadow) {
            fontRenderer.func_175063_a(string, (float)(1 + x + w / 2 - sw / 2), (float)(1 + y + h / 2 - sh / 2), color);
        } else {
            fontRenderer.func_78276_b(string, 1 + x + w / 2 - sw / 2, 1 + y + h / 2 - sh / 2, color);
        }
    }

    public static void drawTextFromBaseline(FontRenderer fontRenderer, String string, int x, int y, int color, boolean shadow) {
        int sh = fontRenderer.func_78267_b(string, 9999999);
        if (shadow) {
            fontRenderer.func_175063_a(string, (float)x, (float)(1 + y - sh), color);
        } else {
            fontRenderer.func_78276_b(string, x, 1 + y - sh, color);
        }
    }

    public static void drawStackCentered(FontRenderer fontRenderer, String string, int x, int y, int w, int h, int color, boolean shadow) {
        int sw = fontRenderer.func_78256_a(string);
        int sh = fontRenderer.func_78267_b(string, 9999999);
        if (shadow) {
            fontRenderer.func_175063_a(string, (float)(1 + x + w / 2 - sw / 2), (float)(1 + y + h / 2 - sh / 2), color);
        } else {
            fontRenderer.func_78276_b(string, 1 + x + w / 2 - sw / 2, 1 + y + h / 2 - sh / 2, color);
        }
    }

    public static StackCountedArray stackCountedArray(Object ... items) {
        ItemStack[] ret = new ItemStack[items.length];
        int i = 0;
        for (Object object : items) {
            ret[i++] = Util.stack(object);
        }
        return new StackCountedArray(ret);
    }

    public static String[] stringArray(String ... arr) {
        return arr;
    }

    public static ArrayList<String> stringList(String ... arr) {
        ArrayList<String> list = new ArrayList<String>(arr.length);
        for (String str : arr) {
            list.add(str);
        }
        return list;
    }

    public static ItemStack[] stackArray(Object ... items) {
        ItemStack[] ret = new ItemStack[items.length];
        int i = 0;
        for (Object object : items) {
            ret[i++] = Util.stack(object);
        }
        return ret;
    }

    public static List<ItemStack> stackList(Object ... items) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(items.length);
        for (Object object : items) {
            ret.add(Util.stack(object));
        }
        return ret;
    }

    public static ItemStack stackMeta(Object obj, int meta) {
        return Util.stack(obj, 1, meta);
    }

    public static ItemStack stackAmount(Object object, int quantity) {
        return Util.stack(object, quantity, 0);
    }

    public static ItemStack stack(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        return Util.stack(object, 1, 0);
    }

    public static ItemStack stack(Object object, int quantity, int meta) {
        if (object instanceof Block) {
            return new ItemStack((Block)object, quantity, meta);
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, quantity, meta);
        }
        if (object instanceof IBlockState) {
            IBlockState bs = (IBlockState)object;
            return new ItemStack(bs.func_177230_c(), quantity, bs.func_177230_c().func_176201_c(bs));
        }
        throw new IllegalArgumentException("object " + object + " of class " + object.getClass() + " is not a valid argument for stack().");
    }

    public static SoundEvent soundEventFromString(String soundEvent) {
        switch (soundEvent.toUpperCase()) {
            case "ENTITY_WITCH_DRINK": {
                return SoundEvents.field_187922_gv;
            }
            case "BLOCK_LAVA_EXTINGUISH": {
                return SoundEvents.field_187659_cY;
            }
        }
        throw new IllegalArgumentException(soundEvent + " is not a valid SoundEventString!");
    }

    public static int stackHash(ItemStack input) {
        return (input.func_77973_b().getRegistryName().toString() + input.func_77960_j()).hashCode();
    }

    public static void showCallStack() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTraceElements.length; ++i) {
            StackTraceElement ste = stackTraceElements[i];
            String classname = ste.getClassName();
            String methodName = ste.getMethodName();
            int lineNumber = ste.getLineNumber();
            System.out.println(classname + "." + methodName + ":" + lineNumber);
        }
    }

    public static String whoCalledMe() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[4];
        String classname = caller.getClassName();
        String methodName = caller.getMethodName();
        int lineNumber = caller.getLineNumber();
        return classname + "." + methodName + ":" + lineNumber;
    }

    public static <T> List<T> listOf(T input1) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(input1);
        return list;
    }

    public static <T> List<T> listOf(T input1, T input2) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(input1);
        list.add(input2);
        return list;
    }

    public static <T> List<T> listOf(T input1, T input2, T input3) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(input1);
        list.add(input2);
        list.add(input3);
        return list;
    }

    public static <T> List<T> listOf(T input1, T input2, T input3, T input4) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(input1);
        list.add(input2);
        list.add(input3);
        list.add(input4);
        return list;
    }

    public static <T> List<T> listOf(T input1, T input2, T input3, T input4, T input5) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(input1);
        list.add(input2);
        list.add(input3);
        list.add(input4);
        list.add(input5);
        return list;
    }

    public static List<ItemStack> listOfOneItemStack(Item item) {
        return Util.listOf(new ItemStack(item));
    }

    public static List<ItemStack> listOfOneItemStack(Block block) {
        return Util.listOf(new ItemStack(block));
    }

    public static <T> T[] arrayOf(T item) {
        return new Object[]{item};
    }

    public static <T> T[] arrayOf(T item1, T item2) {
        return new Object[]{item1, item2};
    }

    public static <T> T[] arrayOf(T item1, T item2, T item3) {
        return new Object[]{item1, item2, item3};
    }

    public static <T> T[] arrayOf(T item1, T item2, T item3, T item4) {
        return new Object[]{item1, item2, item3, item4};
    }

    public static <T> T[] arrayOf(T item1, T item2, T item3, T item4, T item5) {
        return new Object[]{item1, item2, item3, item4, item5};
    }

    public static <T> NonNullList<T> nnlist(T ingr1, T ingr2) {
        NonNullList nnlist = NonNullList.func_191196_a();
        nnlist.add(ingr1);
        nnlist.add(ingr2);
        return nnlist;
    }

    public static <T> NonNullList<T> nnlist(T ingr1, T ingr2, T ingr3) {
        NonNullList nnlist = NonNullList.func_191196_a();
        nnlist.add(ingr1);
        nnlist.add(ingr2);
        nnlist.add(ingr3);
        return nnlist;
    }

    public static <T> NonNullList<T> nnlist(T ingr1, T ingr2, T ingr3, T ingr4) {
        NonNullList nnlist = NonNullList.func_191196_a();
        nnlist.add(ingr1);
        nnlist.add(ingr2);
        nnlist.add(ingr3);
        nnlist.add(ingr4);
        return nnlist;
    }

    public static <T> NonNullList<T> nnlist(T ingr1, T ingr2, T ingr3, T ingr4, T ingr5) {
        NonNullList nnlist = NonNullList.func_191196_a();
        nnlist.add(ingr1);
        nnlist.add(ingr2);
        nnlist.add(ingr3);
        nnlist.add(ingr4);
        nnlist.add(ingr5);
        return nnlist;
    }

    public static Object getFieldFromBlockClass(Block block, String string, Class<?> clazz) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field blockHardnessField = Block.class.getDeclaredField("blockHardness");
        if (blockHardnessField != null) {
            blockHardnessField.setAccessible(true);
            Object ob = blockHardnessField.get(block);
            if (ob.getClass().equals(clazz)) {
                return ob;
            }
        }
        return null;
    }

    public static IBlockState[] stackToState(ItemStack[] stacks) {
        IBlockState[] ret = new IBlockState[stacks.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Util.stackToState(stacks[i]);
        }
        return ret;
    }

    public static IBlockState stackToState(ItemStack stack) {
        if (!Util.isValid(stack)) {
            return null;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return null;
        }
        return block.func_176203_a(stack.func_77960_j());
    }

    public static Ingredient ingr(Object item) {
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{Util.stack(item)});
    }

    public static <T> NonNullList<T> nnlist(T ingr) {
        NonNullList nnlist = NonNullList.func_191196_a();
        nnlist.add(ingr);
        return nnlist;
    }

    public static boolean tryInsert(IItemHandler itemHandler, ItemStack stack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (Util.isValid(itemHandler.insertItem(slot, stack, simulate))) continue;
            return true;
        }
        return false;
    }

    public static BlockPos closestPointNear(BlockPos origin, BlockPos pos) {
        BlockPos nearest = origin;
        double distSq = 2.147483647E9;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos tempPos = pos.func_177982_a(x, y, z);
                    double tempDistSq = tempPos.func_177951_i((Vec3i)origin);
                    if (!(tempDistSq < distSq)) continue;
                    nearest = tempPos;
                    distSq = tempDistSq;
                }
            }
        }
        return nearest;
    }

    public static LinkedList<BlockPos> getPositionsAround(BlockPos pos) {
        LinkedList<BlockPos> near = new LinkedList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    near.add(pos.func_177982_a(x, y, z));
                }
            }
        }
        return near;
    }

    public static void removeItemFromInventory(EntityPlayer player, ItemStack itemStack) {
        InventoryPlayer inv = player.field_71071_by;
        for (int n = 0; n < itemStack.func_190916_E(); ++n) {
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack slotStack = inv.func_70301_a(slot);
                if (!Util.isValid(slotStack) || !Util.equalExceptAmount(slotStack, itemStack)) continue;
                inv.func_70298_a(slot, 1);
            }
        }
    }

    public static boolean checkItemExistsInInventory(EntityPlayer player, ItemStack itemStack) {
        InventoryPlayer inv = player.field_71071_by;
        int count = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (!Util.isValid(slotStack) || !Util.equalExceptAmount(slotStack, itemStack)) continue;
            count += slotStack.func_190916_E();
        }
        return count >= itemStack.func_190916_E();
    }

    public static ItemStack tryExtract(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!Util.equalExceptAmount(itemHandler.getStackInSlot(slot), itemStack)) continue;
            return itemHandler.extractItem(slot, itemStack.func_190916_E(), simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean canEntityGoTo(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == null;
    }

    public static void scheduleTask(final MinecraftServer server, long timeout, final Runnable runnable) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                server.func_152344_a(runnable);
            }
        }, timeout);
    }

    public static Vec3d getYawPitchFromCoords(Vec3d first_location, Vec3d second_location) {
        double dX = first_location.field_72450_a - second_location.field_72450_a;
        double dY = first_location.field_72448_b - second_location.field_72448_b;
        double dZ = first_location.field_72449_c - second_location.field_72449_c;
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        return new Vec3d(yaw, pitch, 0.0);
    }

    public static IItemHandler getItemHandler(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (!te.hasCapability(cap, facing) || (itemHandler = (IItemHandler)te.getCapability(cap, facing)) == null) continue;
            return itemHandler;
        }
        return null;
    }

    public static class StackCountedArray {
        private ItemStack[] array;

        public StackCountedArray(ItemStack[] ret) {
            this.array = ret;
        }

        public ItemStack[] setCounts(int ... counts) {
            for (int i = 0; i < counts.length; ++i) {
                this.array[i].func_190920_e(counts[i]);
            }
            return this.array;
        }

        public StackCountedArray setCountsAnd(int ... counts) {
            for (int i = 0; i < counts.length; ++i) {
                this.array[i].func_190920_e(counts[i]);
            }
            return this;
        }

        public ItemStack[] setMetas(int ... metas) {
            for (int i = 0; i < metas.length; ++i) {
                this.array[i].func_77964_b(metas[i]);
            }
            return this.array;
        }

        public StackCountedArray setMetasAnd(int ... metas) {
            for (int i = 0; i < metas.length; ++i) {
                this.array[i].func_77964_b(metas[i]);
            }
            return this;
        }
    }

    public static class BlockWithMeta {
        public final Block block;
        public final int meta;
        public boolean inverse = false;

        public BlockWithMeta(Block block) {
            this.block = block;
            this.meta = -1;
        }

        public BlockWithMeta(Block block, int meta, boolean ... inverse) {
            this.block = block;
            this.meta = meta;
            this.inverse = inverse.length > 0 && inverse[0];
        }
    }
}

