/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGolemsHut
extends Block {
    public final int range;
    private final String rangeString;
    private final String fullSizeString;

    public BlockGolemsHut(int range, String rangeString, String fullSizeString) {
        super(Material.field_151575_d);
        this.range = range;
        this.rangeString = rangeString;
        this.fullSizeString = fullSizeString;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!(placer instanceof EntityPlayer)) {
            return;
        }
        boolean otherHutsPresent = this.checkOtherHutsPresent(world, pos);
        if (otherHutsPresent) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)this)));
            }
            world.func_175698_g(pos);
        }
    }

    private boolean checkOtherHutsPresent(World world, BlockPos pos) {
        for (int x = -this.range; x <= this.range; ++x) {
            for (int y = -this.range; y <= this.range; ++y) {
                for (int z = -this.range; z <= this.range; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !(world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() instanceof BlockGolemsHut)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add("Place me on the ground, preferably flush with the floor.");
        tooltip.add("Place some chests on top or very close, with rope inside.");
        tooltip.add(this.rangeString + " blocks of radius. " + this.fullSizeString);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }
}

