/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wolforce.minergolems.MinerGolems;
import wolforce.minergolems.Util;
import wolforce.minergolems.blocks.BlockGolemsHut;
import wolforce.minergolems.entities.EntityGolemsBucket;

public class BlockGolemsRope
extends Block {
    public static final PropertyBool HAS_BOTTOM = PropertyBool.func_177716_a((String)"has_bottom");
    private static final double F = 0.0625;
    private static final AxisAlignedBB BOUNDBOX = new AxisAlignedBB(0.375, 0.0, 0.0625, 0.625, 1.0, 0.9375);

    public BlockGolemsRope() {
        super(Material.field_151580_n);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add("Place me under containers, and right click me with items.");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.OFF_HAND) || player.func_70093_af()) {
            return false;
        }
        ItemStack handStack = player.func_184586_b(hand);
        if (this.tryDeliver(0.2, world, pos, handStack)) {
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        return true;
    }

    public boolean tryDeliver(double value, World world, BlockPos pos, ItemStack handStack) {
        boolean otherBucketExist;
        boolean handStackIsValid = Util.isValid(handStack);
        boolean bl = otherBucketExist = world.func_72872_a(EntityGolemsBucket.class, new AxisAlignedBB(pos)).size() > 0;
        if (handStackIsValid && !otherBucketExist) {
            if (!world.field_72995_K) {
                EntityGolemsBucket entityBucket = new EntityGolemsBucket(world, pos, handStack);
                world.func_72838_d((Entity)entityBucket);
            }
            return true;
        }
        if (!world.field_72995_K) {
            int nRopeUp = this.getAllRopes(world, pos, true);
            int nRopeDown = this.getAllRopes(world, pos, false);
            List entities = world.func_72872_a(EntityGolemsBucket.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - nRopeDown), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + nRopeUp), (double)(pos.func_177952_p() + 1)));
            for (EntityGolemsBucket entityGolemsBucket : entities) {
                entityGolemsBucket.moveUp(value);
            }
        }
        return false;
    }

    private int getAllRopes(World world, BlockPos _pos, boolean up) {
        int count = 0;
        BlockPos pos = _pos;
        while (world.func_180495_p(pos).func_177230_c() == MinerGolems.golems_rope) {
            ++count;
            pos = up ? pos.func_177984_a() : pos.func_177977_b();
        }
        return count + (up ? 0 : 1);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.testAndBreak(world, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_BOTTOM, (Comparable)Boolean.valueOf(this.hasBottom(world, pos)));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean broke = this.testAndBreak(world, pos);
        if (!broke) {
            world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)HAS_BOTTOM, (Comparable)Boolean.valueOf(this.hasBottom(world, pos))));
        }
    }

    private boolean testAndBreak(World world, BlockPos pos) {
        BlockPos posUp = pos.func_177984_a();
        boolean hasContainerOnTop = Util.getItemHandler(world, posUp) != null;
        boolean hasSolidTop = world.func_180495_p(posUp).isSideSolid((IBlockAccess)world, posUp, EnumFacing.DOWN);
        boolean hasRopeOnTop = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGolemsRope;
        boolean hasHutOnTop = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGolemsHut;
        if (!(hasSolidTop || hasRopeOnTop || hasHutOnTop || hasContainerOnTop)) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack((Block)this)));
            }
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    private boolean hasBottom(World world, BlockPos pos) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        boolean hasRopeBellow = stateDown.func_177230_c() instanceof BlockGolemsRope;
        boolean hasSolidBlockBellow = stateDown.func_177230_c().func_185481_k(stateDown);
        return !hasRopeBellow && !hasSolidBlockBellow;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_BOTTOM});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_BOTTOM, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_BOTTOM) != false ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDBOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

