/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.entities;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wolforce.minergolems.MinerGolems;
import wolforce.minergolems.Util;
import wolforce.minergolems.blocks.BlockGolemsHut;

public class EntityGolemsBucket
extends Entity {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityGolemsBucket.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityGolemsBucket(World worldIn) {
        super(worldIn);
    }

    public EntityGolemsBucket(World world, BlockPos pos, ItemStack stack) {
        this(world);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
        this.setStack(stack);
    }

    protected void func_70088_a() {
        float f = 0.0625f;
        this.func_70105_a(f * 5.0f, f * 5.0f);
        this.func_184212_Q().func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_70030_z() {
        Block block;
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!Util.isValid(this.getStack())) {
            this.func_70106_y();
        }
        if ((block = this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c()) != MinerGolems.golems_rope) {
            Util.spawnItem(this.field_70170_p, this.func_180425_c(), this.getStack(), new double[0]);
            this.func_70106_y();
        }
    }

    public void moveUp(double value) {
        this.func_70634_a(this.field_70165_t, this.field_70163_u + value, this.field_70161_v);
        BlockPos pos = this.func_180425_c();
        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockGolemsHut) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    TileEntity te = this.field_70170_p.func_175625_s(pos.func_177982_a(x, 1, z));
                    if (te == null || !this.tryDeposit(te)) continue;
                    this.setStack(ItemStack.field_190927_a);
                    this.func_70106_y();
                }
            }
        } else {
            TileEntity te = this.field_70170_p.func_175625_s(pos);
            if (te != null && this.tryDeposit(te)) {
                this.setStack(ItemStack.field_190927_a);
                this.func_70106_y();
            }
        }
    }

    private boolean tryDeposit(TileEntity te) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (!te.hasCapability(cap, facing) || !Util.tryInsert(itemHandler = (IItemHandler)te.getCapability(cap, facing), this.getStack(), false)) continue;
            return true;
        }
        return false;
    }

    private void setStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(STACK, (Object)stack);
    }

    public ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(STACK);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        NBTBase stackNbt;
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("stack") && (stackNbt = nbt.func_74781_a("stack")) != null && stackNbt instanceof NBTTagCompound) {
            ItemStack stack = new ItemStack((NBTTagCompound)stackNbt);
            this.setStack(stack);
        }
    }

    public void func_70014_b(NBTTagCompound _nbt) {
        NBTTagCompound nbt = _nbt == null ? new NBTTagCompound() : _nbt;
        nbt.func_74782_a("stack", (NBTBase)this.getStack().serializeNBT());
    }
}

