/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.entities;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import wolforce.minergolems.Config;
import wolforce.minergolems.MinerGolems;
import wolforce.minergolems.Util;
import wolforce.minergolems.blocks.BlockGolemsHut;
import wolforce.minergolems.entities.ai.MinerAI_0_GetOutOfWater;
import wolforce.minergolems.entities.ai.MinerAI_1_FindHut;
import wolforce.minergolems.entities.ai.MinerAI_2_DeliverItem;
import wolforce.minergolems.entities.ai.MinerAI_3_RequestPayment;
import wolforce.minergolems.entities.ai.MinerAI_4_GoUp;
import wolforce.minergolems.entities.ai.MinerAI_5_GoDown;
import wolforce.minergolems.entities.ai.MinerAI_6_GrabDroppedItem;
import wolforce.minergolems.entities.ai.MinerAI_7_FindAndBreakBlock;
import wolforce.minergolems.entities.ai.MinerAI_8_GoNearbyHut;

public class EntityMiner
extends EntityCreature {
    private static final String[] names = new String[]{"Aaron", "Abe", "Arnold", "Art", "Billy", "Bob", "Bert", "Brian", "Calvin", "Chad", "Dale", "Daryl", "David", "Derek", "Dick", "Ed", "Evan", "Frank", "Fred", "Gary", "George", "Gus", "Hank", "Henry", "Ike", "Jack", "Jeff", "Joe", "John", "Jon", "Kevin", "Larry", "Lee", "Max", "Nate", "Paul", "Ray", "Rick", "Ryan", "Sam", "Steve", "Ted", "Tom", "Walter", "Zack"};
    private static final double SPEED_NORMAL = 0.5;
    private static final double SPEED_WEIGHT = 0.3;
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> MONEY = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_ASKING = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MINING = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> JOB = EntityDataManager.func_187226_a(EntityMiner.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final EnumFacing[] allFacesButDown = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP};
    private BlockPos ropePos;
    private BlockPos hutPos = null;
    private int idleTimer;

    public EntityMiner(World worldIn, BlockPos pos) {
        this(worldIn);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public EntityMiner(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.5f, 0.75f);
        this.func_184212_Q().func_187214_a(STACK, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(MONEY, (Object)0);
        this.func_184212_Q().func_187214_a(IS_ASKING, (Object)false);
        this.func_184212_Q().func_187214_a(MINING, (Object)0);
        this.func_184212_Q().func_187214_a(JOB, (Object)0);
        if (!this.func_145818_k_()) {
            this.func_96094_a(names[(int)(Math.random() * (double)names.length)]);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MinerAI_0_GetOutOfWater(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MinerAI_1_FindHut(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MinerAI_2_DeliverItem(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MinerAI_3_RequestPayment(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MinerAI_4_GoUp(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MinerAI_5_GoDown(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new MinerAI_6_GrabDroppedItem(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new MinerAI_7_FindAndBreakBlock(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new MinerAI_8_GoNearbyHut(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMiner.class, 10.0f){

            public boolean func_75250_a() {
                if (!EntityMiner.this.hasMoney()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this){

            public boolean func_75250_a() {
                if (!EntityMiner.this.hasMoney()) {
                    return false;
                }
                return super.func_75250_a();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean canStand(BlockPos pos) {
        return this.func_70661_as().func_188555_b(pos);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_76355_l().equals("fall")) {
            return;
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.func_70781_l()) {
            this.increaseIdleTimer();
        }
        this.ropePos = this.getFinalRopePos();
    }

    public BlockPos getRopePos() {
        return this.ropePos;
    }

    private BlockPos getFinalRopePos() {
        if (!this.hasHut()) {
            return null;
        }
        BlockPos pos = this.getHutPos().func_177977_b();
        while (this.field_70170_p.func_180495_p(pos).func_177230_c() == MinerGolems.golems_rope) {
            pos = pos.func_177977_b();
        }
        return pos.func_177984_a();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (player.func_70093_af()) {
            this.nextJob();
            this.resetMining();
            this.clearPath();
            this.resetIdleTimer();
            return EnumActionResult.SUCCESS;
        }
        ItemStack handStack = player.func_184586_b(hand);
        if (Util.isValid(handStack)) {
            int handValue = this.isMoney(handStack);
            if (this.isAsking() && handValue > 0) {
                this.resetIdleTimer();
                this.setMoney(handValue);
                if (!player.func_184812_l_()) {
                    handStack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_184199_a(player, vec, hand);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            Util.spawnItem(this.field_70170_p, this.func_180425_c(), this.getStack(), new double[0]);
        }
        super.func_70645_a(cause);
    }

    public boolean goToHut() {
        return this.path((Vec3i)this.hutPos.func_177984_a());
    }

    public void clearPath() {
        this.func_70661_as().func_75499_g();
    }

    public boolean path(Vec3d positionVector) {
        return this.func_70661_as().func_75492_a(positionVector.field_72450_a, positionVector.field_72448_b, positionVector.field_72449_c, this.getSpeed());
    }

    public boolean path(Vec3i position) {
        if (this.path(new Vec3d(position).func_72441_c(0.5, 0.5, 0.5))) {
            return true;
        }
        if (this.path(new Vec3d(position))) {
            return true;
        }
        for (double x = 0.0; x <= 1.0; x += 0.5) {
            for (double y = 0.0; y <= 1.0; y += 0.5) {
                for (double z = 0.0; z <= 1.0; z += 0.5) {
                    if (!this.path(new Vec3d(position).func_72441_c(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean pathToFaceOf(BlockPos targetBlock, double minDistance) {
        for (EnumFacing face : allFacesButDown) {
            PathPoint finalPoint;
            Path path;
            BlockPos facePos = targetBlock.func_177972_a(face);
            if (!Util.canEntityGoTo(this.field_70170_p, facePos) || (path = this.func_70661_as().func_179680_a(facePos)) == null || (finalPoint = path.func_75870_c()) == null || !(targetBlock.func_177954_c((double)finalPoint.field_75839_a, (double)finalPoint.field_75837_b, (double)finalPoint.field_75838_c) < minDistance)) continue;
            return this.path((Vec3i)facePos);
        }
        return this.path((Vec3i)targetBlock);
    }

    public boolean isIdle() {
        if (this.idleTimer > 20 && this.idleTimer % 20 != 0) {
            return true;
        }
        return this.idleTimer > 1200 && this.idleTimer % 50 != 0;
    }

    private void increaseIdleTimer() {
        ++this.idleTimer;
    }

    public void resetIdleTimer() {
        this.idleTimer = 0;
    }

    public int getIdleTimer() {
        return this.idleTimer;
    }

    public double getSpeed() {
        return this.hasStack() ? 0.3 : 0.5;
    }

    public void setStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(STACK, (Object)stack);
    }

    public ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(STACK);
    }

    public boolean hasStack() {
        return Util.isValid(this.getStack());
    }

    public int getMoney() {
        return (Integer)this.func_184212_Q().func_187225_a(MONEY);
    }

    public void setMoney(int money) {
        this.func_184212_Q().func_187227_b(MONEY, (Object)money);
    }

    public boolean hasMoney() {
        return this.getMoney() > 0;
    }

    public void useMoney(int value) {
        this.setMoney(Math.max(0, this.getMoney() - value));
    }

    public void isAsking(boolean b) {
        this.func_184212_Q().func_187227_b(IS_ASKING, (Object)b);
    }

    public boolean isAsking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ASKING);
    }

    public int isMoney(ItemStack stack) {
        for (int i = 0; i < Config.offers.length; ++i) {
            String offer = Config.offers[i];
            String[] split = offer.split(":");
            if (!(split.length == 3 ? stack.func_77973_b().getRegistryName().toString().equals(split[0] + ":" + split[1]) && stack.func_77960_j() == Integer.parseInt(split[2]) : stack.func_77973_b().getRegistryName().toString().equals(offer))) continue;
            return Config.values[i];
        }
        return 0;
    }

    private int getJob() {
        return (Integer)this.func_184212_Q().func_187225_a(JOB);
    }

    private void setJob(int value) {
        this.func_184212_Q().func_187227_b(JOB, (Object)value);
    }

    public EnumJob getJobEnum() {
        int jobIndex = this.getJob();
        if (jobIndex >= 0 && jobIndex < EnumJob.values().length) {
            return EnumJob.values()[jobIndex];
        }
        return EnumJob.NOTHING;
    }

    public void nextJob() {
        int jobIndex = this.getJob() + 1;
        if (jobIndex >= EnumJob.values().length) {
            jobIndex = 0;
        }
        this.setJob(jobIndex);
    }

    public ItemStack getJobsStackImage() {
        switch (this.getJobEnum()) {
            case MINER: {
                return new ItemStack(Items.field_151035_b);
            }
            case CLEANER: {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return null;
    }

    public int getMining() {
        return (Integer)this.func_184212_Q().func_187225_a(MINING);
    }

    public boolean isMining() {
        return (Integer)this.func_184212_Q().func_187225_a(MINING) > 0;
    }

    public void resetMining() {
        this.func_184212_Q().func_187227_b(MINING, (Object)0);
    }

    public void startMining() {
        this.func_184212_Q().func_187227_b(MINING, (Object)1);
    }

    public void increaseMining(int value) {
        int newValue = this.getMining() + value;
        this.func_184212_Q().func_187227_b(MINING, (Object)newValue);
    }

    public BlockPos getHutPos() {
        return this.hutPos;
    }

    public void setHutPos(BlockPos pos) {
        this.hutPos = pos;
    }

    public boolean hasHut() {
        return this.getHutRange(this.field_70170_p) > 0;
    }

    public int getHutRange(World world) {
        if (this.hutPos == null) {
            return 0;
        }
        Block block = world.func_180495_p(this.hutPos).func_177230_c();
        if (!(block instanceof BlockGolemsHut)) {
            return 0;
        }
        return ((BlockGolemsHut)block).range;
    }

    public float func_70047_e() {
        return 0.625f;
    }

    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return super.func_184601_bQ(source);
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        NBTBase stackNbt;
        super.func_70037_a(nbt);
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("stack") && (stackNbt = nbt.func_74781_a("stack")) != null && stackNbt instanceof NBTTagCompound) {
            ItemStack stack = new ItemStack((NBTTagCompound)stackNbt);
            this.setStack(stack);
        }
        if (nbt.func_74764_b("money")) {
            this.setMoney(nbt.func_74762_e("money"));
        }
        if (nbt.func_74764_b("job")) {
            this.setJob(nbt.func_74762_e("job"));
        }
        if (nbt.func_74764_b("hut_pos")) {
            int[] hutPosValues = nbt.func_74759_k("hut_pos");
            this.setHutPos(new BlockPos(hutPosValues[0], hutPosValues[1], hutPosValues[2]));
        }
    }

    public void func_70014_b(NBTTagCompound _nbt) {
        NBTTagCompound nbt = _nbt == null ? new NBTTagCompound() : _nbt;
        nbt.func_74782_a("stack", (NBTBase)this.getStack().serializeNBT());
        nbt.func_74768_a("money", this.getMoney());
        nbt.func_74768_a("job", this.getJob());
        if (this.hutPos != null) {
            nbt.func_74783_a("hut_pos", new int[]{this.hutPos.func_177958_n(), this.hutPos.func_177956_o(), this.hutPos.func_177952_p()});
        }
        super.func_70014_b(nbt);
    }

    public static enum EnumJob {
        NOTHING,
        MINER,
        CLEANER;

    }
}

