/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.entities.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import wolforce.minergolems.Config;
import wolforce.minergolems.entities.EntityMiner;

public abstract class MinerAIBase
extends EntityAIBase {
    protected static final float melee_distance = 4.0f;
    protected final World world;
    protected final EntityMiner miner;
    protected BlockPos ropePos;
    protected String name;

    public MinerAIBase(EntityMiner theCreatureIn, String name) {
        this.miner = theCreatureIn;
        this.name = name;
        this.world = theCreatureIn.field_70170_p;
        this.func_75248_a(5);
    }

    public final boolean func_75250_a() {
        boolean willExecute;
        this.ropePos = this.miner.getRopePos();
        boolean bl = willExecute = this.shouldExecute2() && !this.miner.isIdle();
        if (willExecute && Config.debug_output) {
            System.out.println((Object)this);
        }
        return willExecute;
    }

    public final void func_75246_d() {
        this.ropePos = this.miner.getRopePos();
        this.execute2();
    }

    protected abstract void execute2();

    protected abstract boolean shouldExecute2();

    protected void notIdle() {
        this.miner.resetIdleTimer();
    }

    protected BlockPos getMinerRelativePos(int x, int y, int z) {
        return this.miner.func_180425_c().func_177982_a(x, y, z);
    }

    protected boolean isAtEndRopeY() {
        if (this.ropePos == null) {
            return true;
        }
        int minerY = (int)Math.floor(this.miner.field_70163_u);
        int ropeDist = this.getRopeDistance();
        if (ropeDist == 0) {
            return minerY == this.miner.getHutPos().func_177956_o();
        }
        int ropeY = this.ropePos.func_177956_o();
        if (ropeDist <= 2) {
            return Math.abs(minerY - ropeY) <= 1;
        }
        return Math.abs(minerY - ropeY) <= 2;
    }

    protected boolean isNear(Vec3d vec3d, double ... maxDistance) {
        return this.miner.func_174791_d().func_72436_e(vec3d) < (maxDistance.length > 0 ? maxDistance[0] : 4.0);
    }

    protected boolean isNear(Vec3i vec3i, double ... maxDistance) {
        return this.isNear(new Vec3d(vec3i).func_72441_c(0.5, 0.5, 0.5), maxDistance);
    }

    protected int getRopeDistance() {
        BlockPos hutPos = this.miner.getHutPos();
        return hutPos.func_177956_o() - this.ropePos.func_177956_o();
    }

    public String toString() {
        return "Task: " + this.name + " (" + this.miner.getIdleTimer() + ")";
    }
}

