/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.entities.ai;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import wolforce.minergolems.Config;
import wolforce.minergolems.entities.EntityMiner;
import wolforce.minergolems.entities.ai.MinerAIBase;

public class MinerAI_3_RequestPayment
extends MinerAIBase {
    private List<EntityPlayer> playersNear;

    public MinerAI_3_RequestPayment(EntityMiner theCreatureIn) {
        super(theCreatureIn, "Request Payment");
    }

    @Override
    public boolean shouldExecute2() {
        this.miner.isAsking(false);
        if (this.miner.getJobEnum() == EntityMiner.EnumJob.NOTHING || !this.miner.hasHut() || this.miner.hasMoney() || this.miner.isMining()) {
            return false;
        }
        this.playersNear = this.getPlayersNear();
        return this.playersNear != null && !this.playersNear.isEmpty();
    }

    @Override
    public void execute2() {
        if (!this.playersNear.isEmpty() && this.tryAsk(this.playersNear)) {
            this.notIdle();
            return;
        }
    }

    private boolean tryAsk(List<EntityPlayer> playersNear) {
        if (playersNear.size() > 1) {
            Collections.sort(playersNear, (o1, o2) -> {
                double d2;
                double d1 = this.miner.func_174791_d().func_72438_d(o1.func_174791_d());
                return d1 < (d2 = this.miner.func_174791_d().func_72438_d(o1.func_174791_d())) ? -1 : (d1 > d2 ? 1 : 0);
            });
        }
        EntityPlayer nearestPlayer = playersNear.get(0);
        double distanceToNearestPlayer = this.miner.func_174791_d().func_72438_d(nearestPlayer.func_174791_d());
        if (distanceToNearestPlayer > Config.min_ask_payment_distance) {
            return false;
        }
        this.miner.isAsking(true);
        this.miner.func_70671_ap().func_75650_a(nearestPlayer.field_70165_t, nearestPlayer.field_70163_u + (double)nearestPlayer.func_70047_e(), nearestPlayer.field_70161_v, (float)this.miner.func_184649_cE(), (float)this.miner.func_70646_bf());
        if (!this.miner.func_70781_l()) {
            this.miner.func_70661_as().func_75497_a((Entity)nearestPlayer, this.miner.getSpeed());
        }
        return true;
    }

    private List<EntityPlayer> getPlayersNear() {
        return this.miner.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.miner.field_70165_t - Config.min_ask_payment_distance, this.miner.field_70163_u - 3.0, this.miner.field_70161_v - Config.min_ask_payment_distance, this.miner.field_70165_t + Config.min_ask_payment_distance, this.miner.field_70163_u + 3.0, this.miner.field_70161_v + Config.min_ask_payment_distance));
    }
}

