/*
 * Decompiled with CFR 0.152.
 */
package wolforce.minergolems.entities.ai;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wolforce.minergolems.Config;
import wolforce.minergolems.MinerGolems;
import wolforce.minergolems.Util;
import wolforce.minergolems.entities.EntityMiner;
import wolforce.minergolems.entities.ai.MinerAIBase;

public class MinerAI_7_FindAndBreakBlock
extends MinerAIBase {
    private static String[] sorted_array = new String[Config.block_blacklist.length];
    private BlockPos targetBlock = null;
    private int timeSpentGoingToOneBlock = 0;

    public MinerAI_7_FindAndBreakBlock(EntityMiner theCreatureIn) {
        super(theCreatureIn, "Find and Break block");
    }

    @Override
    public boolean shouldExecute2() {
        if (this.miner.getJobEnum() != EntityMiner.EnumJob.MINER) {
            return false;
        }
        return this.miner.hasHut() && !this.miner.hasStack() && this.miner.hasMoney();
    }

    @Override
    public void execute2() {
        if (this.miner.func_70781_l()) {
            if (this.targetBlock != null && this.world.func_175623_d(this.targetBlock) && !this.world.func_175623_d(this.targetBlock.func_177977_b())) {
                this.targetBlock = null;
                this.miner.resetMining();
                this.miner.func_70661_as().func_75499_g();
            }
            this.notIdle();
            ++this.timeSpentGoingToOneBlock;
            if (this.timeSpentGoingToOneBlock > 1000) {
                this.timeSpentGoingToOneBlock = 0;
                this.targetBlock = null;
            }
        }
        if (this.getRopeDistance() == 0) {
            this.goAndTryPlaceRope(this.miner.getHutPos().func_177977_b(), true);
            this.notIdle();
            return;
        }
        if (this.targetBlock == null) {
            this.findNewTargetBlock();
            if (this.targetBlock != null) {
                this.notIdle();
            } else {
                this.goAndTryPlaceRope(this.ropePos.func_177977_b(), false);
                this.notIdle();
            }
            return;
        }
        if (this.isNear(new Vec3d((Vec3i)this.targetBlock), new double[0])) {
            this.mine(this.targetBlock, false);
            this.notIdle();
        } else if (this.isAtEndRopeY()) {
            if (!this.miner.pathToFaceOf(this.targetBlock, 4.0)) {
                this.miner.pathToFaceOf(this.ropePos, 4.0);
            }
            this.notIdle();
        }
    }

    private void goAndTryPlaceRope(BlockPos pos, boolean noRope) {
        if (this.world.func_175623_d(pos)) {
            if (this.isNear((Vec3i)pos, new double[0])) {
                this.extractRopeAndPlace();
            } else {
                this.miner.pathToFaceOf(pos.func_177984_a(), 4.0);
            }
        } else if (noRope) {
            if (this.isNear((Vec3i)pos.func_177984_a(), new double[0])) {
                if (this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h) {
                    this.mine(pos, true);
                }
            } else {
                this.miner.goToHut();
            }
        } else if (this.isNear((Vec3i)pos, new double[0])) {
            if (this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h) {
                this.mine(pos, false);
            }
        } else {
            this.miner.pathToFaceOf(pos, 4.0);
        }
    }

    private void findNewTargetBlock() {
        LinkedList<BlockPos> blocks = this.getBlocks();
        if (blocks == null || blocks.isEmpty() || this.onlyAirBlocks(blocks)) {
            return;
        }
        Collections.sort(blocks, (o1, o2) -> {
            double d2;
            double d1 = this.miner.getHutPos().func_177951_i((Vec3i)o1);
            return d1 < (d2 = this.miner.getHutPos().func_177951_i((Vec3i)o2)) ? -1 : (d1 > d2 ? 1 : 0);
        });
        int finalBlockIndex = Math.min(blocks.size() - 1, (int)(Math.random() * 4.0));
        this.targetBlock = blocks.get(finalBlockIndex);
    }

    private boolean onlyAirBlocks(LinkedList<BlockPos> blocks) {
        for (BlockPos blockPos : blocks) {
            if (this.world.func_175623_d(blockPos)) continue;
            return false;
        }
        return true;
    }

    private void extractRopeAndPlace() {
        if (!this.HutHasRope()) {
            return;
        }
        this.notIdle();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                TileEntity te = this.world.func_175625_s(this.miner.getHutPos().func_177982_a(x, 1, z));
                if (te == null || !Util.isValid(this.extractRope(te))) continue;
                this.world.func_175656_a(this.ropePos.func_177977_b(), MinerGolems.golems_rope.func_176223_P());
                return;
            }
        }
    }

    private ItemStack extractRope(TileEntity te) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!te.hasCapability(cap, facing)) continue;
            IItemHandler itemHandler = (IItemHandler)te.getCapability(cap, facing);
            return Util.tryExtract(itemHandler, new ItemStack(MinerGolems.golems_rope), false);
        }
        return ItemStack.field_190927_a;
    }

    private boolean HutHasRope() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                TileEntity te = this.world.func_175625_s(this.miner.getHutPos().func_177982_a(x, 1, z));
                if (te == null || !this.hasRope(te)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRope(TileEntity te) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (!te.hasCapability(cap, facing) || !Util.isValid(Util.tryExtract(itemHandler = (IItemHandler)te.getCapability(cap, facing), new ItemStack(MinerGolems.golems_rope), true))) continue;
            return true;
        }
        return false;
    }

    private LinkedList<BlockPos> getBlocks() {
        int ropeDist = this.getRopeDistance();
        for (int i = Math.max(1, ropeDist - 4); i <= ropeDist; ++i) {
            LinkedList<BlockPos> blocks = this.getBlocksToMineAround(this.miner.getHutPos().func_177979_c(i), true);
            if (blocks == null || blocks.isEmpty()) continue;
            return blocks;
        }
        return null;
    }

    private void mine(BlockPos pos, boolean ignoreSide) {
        this.timeSpentGoingToOneBlock = 0;
        if (this.world.func_175623_d(pos) && pos.func_177956_o() == this.ropePos.func_177956_o() && this.world.func_175623_d(pos.func_177977_b())) {
            this.placeScaffold(pos);
            return;
        }
        this.miner.increaseMining(1);
        IBlockState bs = this.world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (this.world.func_175623_d(pos) || !this.shouldMineBlock(pos, ignoreSide)) {
            this.targetBlock = null;
            this.miner.resetMining();
            return;
        }
        if ((double)this.miner.getMining() >= (double)bs.func_185887_b(this.world, pos) * Config.timeToMine) {
            NonNullList drops = NonNullList.func_191196_a();
            block.getDrops(drops, (IBlockAccess)this.world, pos, bs, 0);
            for (ItemStack itemStack : drops) {
                Util.spawnItem(this.world, pos, itemStack, new double[0]);
            }
            this.miner.useMoney(1);
            this.world.func_175655_b(pos, false);
            if (this.world.func_175623_d(pos.func_177977_b())) {
                this.placeScaffold(pos.func_177977_b());
            }
            pos = null;
            this.miner.resetMining();
            this.targetBlock = null;
        }
    }

    private void placeScaffold(BlockPos pos) {
        this.world.func_175656_a(pos, MinerGolems.golems_scaffold.func_176223_P());
    }

    private boolean shouldMineBlock(BlockPos pos) {
        return this.shouldMineBlock(pos, false);
    }

    private boolean shouldMineBlock(BlockPos pos, boolean ignoreSide) {
        boolean hasAvailableSide;
        Block block = this.world.func_180495_p(pos).func_177230_c();
        boolean isBedrock = block == Blocks.field_150357_h;
        boolean isRope = block == MinerGolems.golems_rope;
        boolean bl = hasAvailableSide = this.hasAvailableSide(pos) || ignoreSide;
        if (isBedrock || isRope || !hasAvailableSide) {
            return false;
        }
        if (Arrays.binarySearch(sorted_array, block.getRegistryName().toString()) >= 0) {
            return false;
        }
        boolean isAir = this.world.func_175623_d(pos);
        boolean needsScaffold = isAir && pos.func_177956_o() == this.ropePos.func_177956_o() && this.world.func_175623_d(pos.func_177977_b());
        return needsScaffold || !isAir;
    }

    private boolean hasAvailableSide(BlockPos pos) {
        for (EnumFacing face : EntityMiner.allFacesButDown) {
            if (!Util.canEntityGoTo(this.world, pos.func_177972_a(face))) continue;
            return true;
        }
        return false;
    }

    private LinkedList<BlockPos> getBlocksToMineAround(BlockPos centerPos, boolean getAll) {
        int maxrange = this.miner.getHutRange(this.world);
        int range = 1;
        LinkedList<BlockPos> blocks = new LinkedList<BlockPos>();
        do {
            BlockPos pos1 = centerPos.func_177982_a(range, 0, 0);
            BlockPos pos2 = centerPos.func_177982_a(-range, 0, 0);
            BlockPos pos3 = centerPos.func_177982_a(0, 0, range);
            BlockPos pos4 = centerPos.func_177982_a(0, 0, -range);
            if (this.shouldMineBlock(pos1)) {
                blocks.add(pos1);
            }
            if (this.shouldMineBlock(pos2)) {
                blocks.add(pos2);
            }
            if (this.shouldMineBlock(pos3)) {
                blocks.add(pos3);
            }
            if (this.shouldMineBlock(pos4)) {
                blocks.add(pos4);
            }
            for (int i = 1; i <= range - 1; ++i) {
                BlockPos pos8;
                BlockPos pos7;
                BlockPos pos6;
                BlockPos pos5;
                BlockPos pos42;
                BlockPos pos32;
                BlockPos pos22;
                BlockPos pos12 = centerPos.func_177982_a(range, 0, -i);
                if (this.shouldMineBlock(pos12)) {
                    blocks.add(pos12);
                }
                if (this.shouldMineBlock(pos22 = centerPos.func_177982_a(-i, 0, range))) {
                    blocks.add(pos22);
                }
                if (this.shouldMineBlock(pos32 = centerPos.func_177982_a(range, 0, i))) {
                    blocks.add(pos32);
                }
                if (this.shouldMineBlock(pos42 = centerPos.func_177982_a(i, 0, range))) {
                    blocks.add(pos42);
                }
                if (this.shouldMineBlock(pos5 = centerPos.func_177982_a(-range, 0, i))) {
                    blocks.add(pos5);
                }
                if (this.shouldMineBlock(pos6 = centerPos.func_177982_a(-range, 0, -i))) {
                    blocks.add(pos6);
                }
                if (this.shouldMineBlock(pos7 = centerPos.func_177982_a(i, 0, -range))) {
                    blocks.add(pos7);
                }
                if (!this.shouldMineBlock(pos8 = centerPos.func_177982_a(-i, 0, -range))) continue;
                blocks.add(pos8);
            }
            if (!blocks.isEmpty() && !getAll) {
                return blocks;
            }
            pos1 = centerPos.func_177982_a(range, 0, range);
            pos2 = centerPos.func_177982_a(-range, 0, range);
            pos3 = centerPos.func_177982_a(-range, 0, -range);
            pos4 = centerPos.func_177982_a(range, 0, -range);
            if (this.shouldMineBlock(pos1)) {
                blocks.add(pos1);
            }
            if (this.shouldMineBlock(pos2)) {
                blocks.add(pos2);
            }
            if (this.shouldMineBlock(pos3)) {
                blocks.add(pos3);
            }
            if (this.shouldMineBlock(pos4)) {
                blocks.add(pos4);
            }
            if (blocks.isEmpty() || getAll) continue;
            return blocks;
        } while (++range <= maxrange);
        return blocks;
    }

    static {
        for (int i = 0; i < Config.block_blacklist.length; ++i) {
            MinerAI_7_FindAndBreakBlock.sorted_array[i] = Config.block_blacklist[i];
        }
        Arrays.sort(sorted_array);
    }
}

