/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.vemerion.mosquitoes.Main;
import mod.vemerion.mosquitoes.capacity.Mosquito;
import mod.vemerion.mosquitoes.capacity.Mosquitoes;
import mod.vemerion.mosquitoes.model.MosquitoModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mosquitoes", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEventSubscriber {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mosquitoes", "textures/entity/mosquito.png");

    @SubscribeEvent
    public static void renderMosquito(RenderHandEvent event) {
        MosquitoModel model = new MosquitoModel();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Mosquitoes mosquitoes = (Mosquitoes)player.getCapability(Main.MOSQUITOES_CAP).orElse((Object)new Mosquitoes());
        for (int i = 0; i < mosquitoes.count(); ++i) {
            Mosquito mosquito = mosquitoes.get(i);
            IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(model.func_228282_a_(TEXTURE));
            model.animate(mosquito, event.getPartialTicks());
            model.renderMosquito(new MatrixStack(), ivertexbuilder, event.getLight(), OverlayTexture.field_229196_a_, mosquito, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void renderSwatter(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.func_77973_b();
        float partialTicks = event.getPartialTicks();
        if (item.equals(Main.SWATTER_ITEM) && player.func_184607_cu().equals(itemStack)) {
            event.setCanceled(true);
            int maxDuration = itemStack.func_77988_m();
            float duration = (float)maxDuration - ((float)player.func_184605_cv() - partialTicks + 1.0f);
            MatrixStack matrix = event.getMatrixStack();
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, -0.2, -0.3);
            matrix.func_227861_a_(0.0, -1.0, 0.0);
            matrix.func_227863_a_(new Quaternion(Math.abs(MathHelper.func_76134_b((float)(duration / 14.0f * (float)Math.PI * 2.0f))) * -30.0f, 90.0f, 0.0f, true));
            matrix.func_227861_a_(0.0, 1.0, 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, event.getLight(), OverlayTexture.field_229196_a_, matrix, event.getBuffers());
            matrix.func_227865_b_();
        }
    }
}

