/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes;

import mod.vemerion.mosquitoes.Main;
import mod.vemerion.mosquitoes.capacity.Mosquitoes;
import mod.vemerion.mosquitoes.capacity.MosquitoesMessage;
import mod.vemerion.mosquitoes.capacity.MosquitoesProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="mosquitoes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    public static final ResourceLocation MOSQUITOES_CAP = new ResourceLocation("mosquitoes", "mosquitoes");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(MOSQUITOES_CAP, (ICapabilityProvider)new MosquitoesProvider());
    }

    @SubscribeEvent
    public static void synchMosquitoesWithClient(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        Mosquitoes mosquitoes = (Mosquitoes)player.getCapability(Main.MOSQUITOES_CAP).orElse((Object)new Mosquitoes());
        MosquitoesMessage.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MosquitoesMessage(mosquitoes.count()));
    }

    @SubscribeEvent
    public static void tickMosquitoes(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntity player = event.player;
            Mosquitoes mosquitoes = (Mosquitoes)player.getCapability(Main.MOSQUITOES_CAP).orElse((Object)new Mosquitoes());
            mosquitoes.tick(player);
        }
    }
}

