/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes;

import mod.vemerion.mosquitoes.capacity.Mosquitoes;
import mod.vemerion.mosquitoes.capacity.MosquitoesMessage;
import mod.vemerion.mosquitoes.capacity.MosquitoesStorage;
import mod.vemerion.mosquitoes.item.SwatterItem;
import net.minecraft.item.Item;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mosquitoes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventSubscriber {
    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(new SwatterItem(), "swatter_item"));
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(Mosquitoes.class, (Capability.IStorage)new MosquitoesStorage(), Mosquitoes::new);
        MosquitoesMessage.INSTANCE.registerMessage(0, MosquitoesMessage.class, MosquitoesMessage::encode, MosquitoesMessage::decode, MosquitoesMessage::handle);
    }

    @SubscribeEvent
    public static void onRegisterSound(RegistryEvent.Register<SoundEvent> event) {
        SoundEvent flying_mosquito_sound = new SoundEvent(new ResourceLocation("mosquitoes", "flying_mosquito_sound"));
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(flying_mosquito_sound, "flying_mosquito_sound"));
        SoundEvent gulp_sound = new SoundEvent(new ResourceLocation("mosquitoes", "gulp_sound"));
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(gulp_sound, "gulp_sound"));
        SoundEvent smack_sound = new SoundEvent(new ResourceLocation("mosquitoes", "smack_sound"));
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(smack_sound, "smack_sound"));
        SoundEvent splash_sound = new SoundEvent(new ResourceLocation("mosquitoes", "splash_sound"));
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(splash_sound, "splash_sound"));
    }

    @SubscribeEvent
    public static void onIParticleTypeRegistration(RegistryEvent.Register<ParticleType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModEventSubscriber.setup(new BasicParticleType(true), "mosquito_particle_type"));
    }

    public static <T extends IForgeRegistryEntry<T>> T setup(T entry, String name) {
        return ModEventSubscriber.setup(entry, new ResourceLocation("mosquitoes", name));
    }

    public static <T extends IForgeRegistryEntry<T>> T setup(T entry, ResourceLocation registryName) {
        entry.setRegistryName(registryName);
        return entry;
    }
}

