/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes.capacity;

import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Mosquito {
    private float x;
    private float y;
    private float prevX;
    private float prevY;
    private float targetX;
    private float targetY;
    private float rotation;
    private float legRotation;
    private float prevLegRotation;
    private int ticksExisted;
    private Random rand;

    public Mosquito(Random rand) {
        this.rand = rand;
        this.targetX = this.randomXPos();
        this.targetY = this.randomYPos();
        this.rotation = rand.nextFloat() * 360.0f;
        this.x = this.randomXPosOutside();
        this.y = this.randomYPosOutside();
        this.prevX = this.x;
        this.prevY = this.y;
    }

    public void tick(PlayerEntity player) {
        ++this.ticksExisted;
        if (player.field_70170_p.field_72995_K) {
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevLegRotation = this.legRotation;
            if (this.isArriving()) {
                Vec3d direction = this.direction();
                this.x = (float)((double)this.x + direction.field_72450_a);
                this.y = (float)((double)this.y + direction.field_72448_b);
                if (this.rand.nextDouble() < 0.3) {
                    this.targetX = this.randomXPos();
                    this.targetY = this.randomYPos();
                }
            } else if (this.isLeaving()) {
                Vec3d direction = this.direction();
                this.x = (float)((double)this.x + direction.field_72450_a);
                this.y = (float)((double)this.y + direction.field_72448_b);
                if (this.ticksExisted() - 1 == this.startsLeavingAfter()) {
                    this.targetX = this.randomXPosOutside();
                    this.targetY = this.randomYPosOutside();
                }
            }
            this.legRotation = this.prevX < this.x ? (float)MathHelper.func_219803_d((double)0.15, (double)this.legRotation, (double)20.0) : (float)MathHelper.func_219803_d((double)0.15, (double)this.legRotation, (double)-20.0);
        }
    }

    private Vec3d direction() {
        Vec3d target = new Vec3d((double)this.targetX, (double)this.targetY, 0.0);
        Vec3d pos = new Vec3d((double)this.x, (double)this.y, 0.0);
        double distance = target.func_72436_e(pos);
        double speed = distance < 0.01 ? 0.0 : (distance < 0.17 ? 0.025 * (distance / 0.17) : 0.025);
        return target.func_178788_d(pos).func_72432_b().func_186678_a(speed);
    }

    private float randomYPos() {
        return this.rand.nextFloat() * 0.35f - 0.175f;
    }

    private float randomXPos() {
        return this.rand.nextFloat() * 0.6f - 0.3f;
    }

    private float randomXPosOutside() {
        return MathHelper.func_76134_b((float)((float)Math.toRadians(this.rotation))) * 1.5f;
    }

    private float randomYPosOutside() {
        return MathHelper.func_76126_a((float)((float)Math.toRadians(this.rotation))) * 1.5f;
    }

    public int ticksExisted() {
        return this.ticksExisted;
    }

    public float getX(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevX, (float)this.x);
    }

    public float getY(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevY, (float)this.y);
    }

    public float getLegRotation(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLegRotation, (float)this.legRotation);
    }

    public float getZ(float partialTicks) {
        float ageInTicks = (float)this.ticksExisted() + partialTicks;
        double z = this.isArriving() ? -0.2 - MathHelper.func_151238_b((double)0.2, (double)0.0, (double)(ageInTicks / (float)this.arrivingDuration())) : (this.isLeaving() ? -0.2 : -0.2);
        return (float)z;
    }

    public float getScale(float partialTicks) {
        return 0.1f;
    }

    public float getRotationX() {
        return this.isArriving() ? -180.0f : (this.isLeaving() ? -180.0f : 90.0f);
    }

    public float getRotationY() {
        return this.isArriving() ? 0.0f : (this.isLeaving() ? 0.0f : this.rotation);
    }

    public int startsSuckingAfter() {
        return 160;
    }

    public int startsLeavingAfter() {
        return 260;
    }

    public int arrivingDuration() {
        return 120;
    }

    public int leavingDuration() {
        return 30;
    }

    public boolean hasArrived() {
        return this.ticksExisted() >= this.arrivingDuration();
    }

    public boolean isArriving() {
        return this.ticksExisted() < this.arrivingDuration();
    }

    public boolean isLeaving() {
        return this.ticksExisted() > this.startsLeavingAfter();
    }

    public boolean hasLeft() {
        return this.ticksExisted() >= this.startsLeavingAfter() + this.leavingDuration();
    }

    public boolean isSucking() {
        return this.ticksExisted() > this.startsSuckingAfter() && this.ticksExisted() < this.startsLeavingAfter();
    }

    public boolean isFlying() {
        return this.isArriving() || this.isLeaving();
    }
}

