/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes.capacity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.vemerion.mosquitoes.Main;
import mod.vemerion.mosquitoes.capacity.Mosquito;
import mod.vemerion.mosquitoes.capacity.MosquitoesMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.network.PacketDistributor;

public class Mosquitoes {
    private List<Mosquito> mosquitoes;
    private Random rand = new Random();
    private int timer;
    private int waves;

    public Mosquitoes() {
        this.mosquitoes = new ArrayList<Mosquito>();
        this.timer = 6000 + this.rand.nextInt(1200);
        this.waves = this.rand.nextInt(2) + 2;
    }

    public void tick(PlayerEntity player) {
        int sucking = 0;
        boolean someoneFlying = false;
        for (Mosquito m : this.mosquitoes) {
            m.tick(player);
            if (m.isSucking()) {
                ++sucking;
            }
            if (!m.isFlying()) continue;
            someoneFlying = true;
        }
        if (!player.field_70170_p.field_72995_K) {
            if (player.field_70173_aa % 10 == 0) {
                player.func_70097_a(DamageSource.field_76377_j, (float)sucking);
            }
            if (this.timer-- < 0) {
                if (this.waves == 0) {
                    this.timer = 6000 + this.rand.nextInt(1200);
                    this.waves = this.rand.nextInt(2) + 2;
                } else {
                    this.timer = 200 + this.rand.nextInt(200);
                    --this.waves;
                }
                int count = this.rand.nextInt(2) + 1;
                this.mosquitoArrives(count);
                MosquitoesMessage.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MosquitoesMessage(count));
            }
        } else if (player.field_70173_aa % 15 == 0) {
            if (someoneFlying) {
                player.func_184185_a(Main.FLYING_MOSQUITO_SOUND, 1.0f, 1.0f);
            }
            if (sucking > 0) {
                player.func_184185_a(Main.GULP_SOUND, 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
            }
        }
        for (int i = this.count() - 1; i >= 0; --i) {
            if (!this.mosquitoes.get(i).hasLeft()) continue;
            this.mosquitoes.remove(i);
        }
    }

    public boolean killMosquitoServer(PlayerEntity player) {
        Mosquito removed = null;
        if (!this.mosquitoes.isEmpty()) {
            removed = this.mosquitoes.remove(0);
        }
        if (removed == null) {
            return false;
        }
        MosquitoesMessage.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MosquitoesMessage(-1));
        return true;
    }

    public boolean killMosquitoClient() {
        Mosquito removed = null;
        if (!this.mosquitoes.isEmpty()) {
            removed = this.mosquitoes.remove(0);
        }
        return removed != null;
    }

    public void mosquitoArrives(int count) {
        for (int i = 0; i < count; ++i) {
            this.mosquitoes.add(new Mosquito(this.rand));
        }
    }

    public int count() {
        return this.mosquitoes.size();
    }

    public Mosquito get(int i) {
        return this.mosquitoes.get(i);
    }
}

