/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.mosquitoes.capacity;

import java.util.Random;
import java.util.function.Supplier;
import mod.vemerion.mosquitoes.Main;
import mod.vemerion.mosquitoes.capacity.Mosquitoes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class MosquitoesMessage {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mosquitoes", "main"), () -> "1", "1"::equals, "1"::equals);
    private int count;

    public MosquitoesMessage(int count) {
        this.count = count;
    }

    public static void encode(MosquitoesMessage msg, PacketBuffer buffer) {
        buffer.writeInt(msg.count);
    }

    public static MosquitoesMessage decode(PacketBuffer buffer) {
        return new MosquitoesMessage(buffer.readInt());
    }

    public static void handle(MosquitoesMessage msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Random rand = player.func_70681_au();
            Mosquitoes mosquitoes = (Mosquitoes)player.getCapability(Main.MOSQUITOES_CAP).orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"));
            if (msg.count > 0) {
                mosquitoes.mosquitoArrives(msg.count);
            } else if (mosquitoes.killMosquitoClient()) {
                player.func_184185_a(Main.SPLASH_SOUND, 1.0f, 0.8f + rand.nextFloat() * 0.4f);
                Vec3d direction = Vec3d.func_189984_a((Vec2f)player.func_189653_aC());
                Vec3d right = direction.func_178785_b(-90.0f);
                Vec3d center = player.func_213303_ch().func_72441_c(direction.field_72450_a * 0.6, 1.6 + direction.field_72448_b * 0.6, direction.field_72449_c * 0.6);
                for (int i = 0; i < 15; ++i) {
                    Vec3d position = center.func_72441_c(right.field_72450_a * (rand.nextDouble() * 1.5 - 0.75), rand.nextDouble() * 1.5 - 0.75, right.field_72449_c * (rand.nextDouble() * 1.5 - 0.75));
                    player.field_70170_p.func_195594_a((IParticleData)Main.MOSQUITO_PARTICLE_TYPE, position.field_72450_a, position.field_72448_b, position.field_72449_c, 0.0, 0.0, 0.0);
                }
            }
        }));
    }
}

